/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.ExtractMode;

public class ISOExtraction
implements Comparable<ISOExtraction> {
    private long id;
    @SerializedName(value="accountid")
    private long accountId;
    private Date created;
    private long extractId;
    private ExtractMode extractMode;
    private String name;
    private String state;
    private String status;
    @SerializedName(value="storagetype")
    private String storageType;
    @SerializedName(value="uploadpercentage")
    private int uploadPercentage;
    private String url;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    ISOExtraction() {
    }

    public long getId() {
        return this.id;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getExtractId() {
        return this.extractId;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    public String getUrl() {
        return this.url;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISOExtraction that = (ISOExtraction)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (this.extractId != that.extractId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.uploadPercentage != that.uploadPercentage) {
            return false;
        }
        if (this.zoneId != that.zoneId) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.extractMode != that.extractMode) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(that.zoneName) : that.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (int)(this.extractId ^ this.extractId >>> 32);
        result = 31 * result + (this.extractMode != null ? this.extractMode.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
        result = 31 * result + this.uploadPercentage;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ISOExtraction{id=" + this.id + ", accountId=" + this.accountId + ", created=" + this.created + ", extractId=" + this.extractId + ", extractMode=" + (Object)((Object)this.extractMode) + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", status='" + this.status + '\'' + ", storageType='" + this.storageType + '\'' + ", uploadPercentage=" + this.uploadPercentage + ", url='" + this.url + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(ISOExtraction other) {
        return new Long(this.id).compareTo(other.getId());
    }

    public static class Builder {
        private long id;
        private long accountId;
        private Date created;
        private long extractId;
        private ExtractMode extractMode;
        private String name;
        private String state;
        private String status;
        private String storageType;
        private int uploadPercentage;
        private String url;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder extractId(long extractId) {
            this.extractId = extractId;
            return this;
        }

        public Builder extractMode(ExtractMode extractMode) {
            this.extractMode = extractMode;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder uploadPercentage(int uploadPercentage) {
            this.uploadPercentage = uploadPercentage;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }
    }
}

