/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;
import java.net.URI;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.TrafficType;

public class NIC {
    private long id;
    @SerializedName(value="broadcasturi")
    private URI broadcastURI;
    private String gateway;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="isdefault")
    private boolean isDefault;
    @SerializedName(value="isolationuri")
    private URI isolationURI;
    private String netmask;
    @SerializedName(value="macaddress")
    private String macAddress;
    @SerializedName(value="networkid")
    private long networkId;
    @SerializedName(value="traffictype")
    private TrafficType trafficType;
    @SerializedName(value="type")
    private GuestIPType guestIPType;

    public static Builder builder() {
        return new Builder();
    }

    NIC() {
    }

    public NIC(long id, URI broadcastURI, String gateway, String iPAddress, boolean isDefault, URI isolationURI, String netmask, String macAddress, long networkId, TrafficType trafficType, GuestIPType guestIPType) {
        this.id = id;
        this.broadcastURI = broadcastURI;
        this.gateway = gateway;
        this.IPAddress = iPAddress;
        this.isDefault = isDefault;
        this.isolationURI = isolationURI;
        this.netmask = netmask;
        this.macAddress = macAddress;
        this.networkId = networkId;
        this.trafficType = trafficType;
        this.guestIPType = guestIPType;
    }

    public long getId() {
        return this.id;
    }

    public URI getBroadcastURI() {
        return this.broadcastURI;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public URI getIsolationURI() {
        return this.isolationURI;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.IPAddress == null ? 0 : this.IPAddress.hashCode());
        result = 31 * result + (this.broadcastURI == null ? 0 : this.broadcastURI.hashCode());
        result = 31 * result + (this.gateway == null ? 0 : this.gateway.hashCode());
        result = 31 * result + (this.guestIPType == null ? 0 : this.guestIPType.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.isolationURI == null ? 0 : this.isolationURI.hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        result = 31 * result + (int)(this.networkId ^ this.networkId >>> 32);
        result = 31 * result + (this.trafficType == null ? 0 : this.trafficType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NIC other = (NIC)obj;
        if (this.IPAddress == null ? other.IPAddress != null : !this.IPAddress.equals(other.IPAddress)) {
            return false;
        }
        if (this.broadcastURI == null ? other.broadcastURI != null : !this.broadcastURI.equals(other.broadcastURI)) {
            return false;
        }
        if (this.gateway == null ? other.gateway != null : !this.gateway.equals(other.gateway)) {
            return false;
        }
        if (this.guestIPType != other.guestIPType) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        if (this.isolationURI == null ? other.isolationURI != null : !this.isolationURI.equals(other.isolationURI)) {
            return false;
        }
        if (this.netmask == null ? other.netmask != null : !this.netmask.equals(other.netmask)) {
            return false;
        }
        if (this.macAddress == null ? other.macAddress != null : !this.macAddress.equals(other.macAddress)) {
            return false;
        }
        if (this.networkId != other.networkId) {
            return false;
        }
        return this.trafficType == other.trafficType;
    }

    public String toString() {
        return "NIC{id=" + this.id + ", broadcastURI=" + this.broadcastURI + ", gateway='" + this.gateway + '\'' + ", IPAddress='" + this.IPAddress + '\'' + ", isDefault=" + this.isDefault + ", isolationURI=" + this.isolationURI + ", netmask='" + this.netmask + '\'' + ", macAddress='" + this.macAddress + '\'' + ", networkId=" + this.networkId + ", trafficType=" + (Object)((Object)this.trafficType) + ", guestIPType=" + (Object)((Object)this.guestIPType) + '}';
    }

    public static class Builder {
        private long id;
        private URI broadcastURI;
        private String gateway;
        private String IPAddress;
        private boolean isDefault;
        private URI isolationURI;
        private String netmask;
        private String macAddress;
        private long networkId;
        private TrafficType trafficType;
        private GuestIPType guestIPType;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder broadcastURI(URI broadcastURI) {
            this.broadcastURI = broadcastURI;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder isolationURI(URI isolationURI) {
            this.isolationURI = isolationURI;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder networkId(long networkId) {
            this.networkId = networkId;
            return this;
        }

        public Builder trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this;
        }

        public NIC build() {
            return new NIC(this.id, this.broadcastURI, this.gateway, this.IPAddress, this.isDefault, this.isolationURI, this.netmask, this.macAddress, this.networkId, this.trafficType, this.guestIPType);
        }
    }
}

