/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.SortedSet;

public class NetworkService
implements Comparable<NetworkService> {
    private String name;
    @SerializedName(value="capability")
    private SortedSet<? extends Capability> capabilities = ImmutableSortedSet.of();

    NetworkService() {
    }

    public NetworkService(String name) {
        this(name, ImmutableMap.of());
    }

    public NetworkService(String name, Map<String, String> capabilities) {
        this.name = Preconditions.checkNotNull(name, "name");
        ImmutableSortedSet.Builder internal = ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, String> capabililty : Preconditions.checkNotNull(capabilities, "capabilities").entrySet()) {
            internal.add(new Capability(capabililty.getKey(), capabililty.getValue()));
        }
        this.capabilities = internal.build();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getCapabilities() {
        ImmutableSortedMap.Builder<String, String> returnVal = ImmutableSortedMap.naturalOrder();
        for (Capability capability : this.capabilities) {
            ((ImmutableMap.Builder)returnVal).put(capability.name, capability.value);
        }
        return ((ImmutableMap.Builder)returnVal).build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkService other = (NetworkService)obj;
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "NetworkService{name='" + this.name + '\'' + ", capabilities=" + this.capabilities + '}';
    }

    @Override
    public int compareTo(NetworkService o) {
        return this.name.compareTo(o.getName());
    }

    private static class Capability
    implements Comparable<Capability> {
        private String name;
        private String value;

        private Capability() {
        }

        private Capability(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Capability other = (Capability)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "[name=" + this.name + ", value=" + this.value + "]";
        }

        @Override
        public int compareTo(Capability o) {
            return this.name.compareTo(o.name);
        }
    }
}

