/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.ExtractMode;

public class TemplateExtraction
implements Comparable<TemplateExtraction> {
    private long id;
    @SerializedName(value="accountid")
    private long accountId;
    private Date created;
    private long extractId;
    private ExtractMode extractMode;
    private String name;
    private String state;
    private String status;
    @SerializedName(value="storagetype")
    private String storageType;
    @SerializedName(value="uploadpercentage")
    private int uploadPercentage;
    private String url;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    public TemplateExtraction(long id, long accountId, Date created, long extractId, ExtractMode extractMode, String name, String state, String status, String storageType, int uploadPercentage, String url, long zoneId, String zoneName) {
        this.id = id;
        this.accountId = accountId;
        this.created = created;
        this.extractId = extractId;
        this.extractMode = extractMode;
        this.name = name;
        this.state = state;
        this.status = status;
        this.storageType = storageType;
        this.uploadPercentage = uploadPercentage;
        this.url = url;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    TemplateExtraction() {
    }

    public long getId() {
        return this.id;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getExtractId() {
        return this.extractId;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    public String getUrl() {
        return this.url;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateExtraction other = (TemplateExtraction)obj;
        return this.id == other.id && this.accountId == other.accountId && Objects.equal(this.created, other.created) && this.extractId == other.extractId && Objects.equal((Object)this.extractMode, (Object)other.extractMode) && Objects.equal(this.name, other.name) && Objects.equal(this.state, other.state) && Objects.equal(this.status, other.status) && Objects.equal(this.storageType, other.storageType) && this.uploadPercentage == other.uploadPercentage && Objects.equal(this.url, other.url) && this.zoneId == other.zoneId && Objects.equal(this.zoneName, other.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName});
    }

    public String toString() {
        return "TemplateExtraction{id=" + this.id + ", accountId=" + this.accountId + ", created=" + this.created + ", extractId=" + this.extractId + ", extractMode=" + (Object)((Object)this.extractMode) + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", status='" + this.status + '\'' + ", storageType='" + this.storageType + '\'' + ", uploadPercentage=" + this.uploadPercentage + ", url='" + this.url + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(TemplateExtraction other) {
        return new Long(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private long accountId;
        private Date created;
        private long extractId;
        private ExtractMode extractMode;
        private String name;
        private String state;
        private String status;
        private String storageType;
        private int uploadPercentage;
        private String url;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder extractId(long extractId) {
            this.extractId = extractId;
            return this;
        }

        public Builder extractMode(ExtractMode extractMode) {
            this.extractMode = extractMode;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder uploadPercentage(int uploadPercentage) {
            this.uploadPercentage = uploadPercentage;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public TemplateExtraction build() {
            return new TemplateExtraction(this.id, this.accountId, this.created, this.extractId, this.extractMode, this.name, this.state, this.status, this.storageType, this.uploadPercentage, this.url, this.zoneId, this.zoneName);
        }
    }
}

