/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;

public class UsageRecord
implements Comparable<UsageRecord> {
    @SerializedName(value="usageid")
    private long id;
    private String description;
    @SerializedName(value="accountid")
    private long accountId;
    @SerializedName(value="account")
    private String accountName;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="startdate")
    private Date startDate;
    @SerializedName(value="enddate")
    private Date endDate;
    @SerializedName(value="assigndate")
    private Date assignDate;
    @SerializedName(value="releasedate")
    private long releaseDate;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="virtualmachineid")
    private long virtualMachineId;
    @SerializedName(value="name")
    private String virtualMachineName;
    @SerializedName(value="offeringid")
    private long serviceOfferingId;
    @SerializedName(value="templateid")
    private long templateId;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="issourcenat")
    private boolean isSourceNAT;
    @SerializedName(value="rawusage")
    private double rawUsageHours;
    @SerializedName(value="usage")
    private String usage;
    private String type;
    @SerializedName(value="usagetype")
    private UsageType usageType;

    public static Builder builder() {
        return new Builder();
    }

    UsageRecord() {
    }

    public UsageRecord(long id, String description, long accountId, String accountName, long domainId, Date startDate, Date endDate, Date assignDate, long releaseDate, long zoneId, long virtualMachineId, String virtualMachineName, long serviceOfferingId, long templateId, String ipAddress, boolean sourceNAT, double rawUsageHours, String usage, String type, UsageType usageType) {
        this.id = id;
        this.description = description;
        this.accountId = accountId;
        this.accountName = accountName;
        this.domainId = domainId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.assignDate = assignDate;
        this.releaseDate = releaseDate;
        this.zoneId = zoneId;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.serviceOfferingId = serviceOfferingId;
        this.templateId = templateId;
        this.ipAddress = ipAddress;
        this.isSourceNAT = sourceNAT;
        this.rawUsageHours = rawUsageHours;
        this.usage = usage;
        this.type = type;
        this.usageType = usageType;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getAssignDate() {
        return this.assignDate;
    }

    public long getReleaseDate() {
        return this.releaseDate;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public long getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public double getRawUsageHours() {
        return this.rawUsageHours;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getType() {
        return this.type;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRecord that = (UsageRecord)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (this.domainId != that.domainId) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.isSourceNAT != that.isSourceNAT) {
            return false;
        }
        if (Double.compare(that.rawUsageHours, this.rawUsageHours) != 0) {
            return false;
        }
        if (this.releaseDate != that.releaseDate) {
            return false;
        }
        if (this.serviceOfferingId != that.serviceOfferingId) {
            return false;
        }
        if (this.templateId != that.templateId) {
            return false;
        }
        if (this.virtualMachineId != that.virtualMachineId) {
            return false;
        }
        if (this.zoneId != that.zoneId) {
            return false;
        }
        if (this.accountName != null ? !this.accountName.equals(that.accountName) : that.accountName != null) {
            return false;
        }
        if (this.assignDate != null ? !this.assignDate.equals(that.assignDate) : that.assignDate != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.usage != null ? !this.usage.equals(that.usage) : that.usage != null) {
            return false;
        }
        if (this.usageType != that.usageType) {
            return false;
        }
        return !(this.virtualMachineName != null ? !this.virtualMachineName.equals(that.virtualMachineName) : that.virtualMachineName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.accountName != null ? this.accountName.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.assignDate != null ? this.assignDate.hashCode() : 0);
        result = 31 * result + (int)(this.releaseDate ^ this.releaseDate >>> 32);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (int)(this.virtualMachineId ^ this.virtualMachineId >>> 32);
        result = 31 * result + (this.virtualMachineName != null ? this.virtualMachineName.hashCode() : 0);
        result = 31 * result + (int)(this.serviceOfferingId ^ this.serviceOfferingId >>> 32);
        result = 31 * result + (int)(this.templateId ^ this.templateId >>> 32);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.isSourceNAT ? 1 : 0);
        long temp = this.rawUsageHours != 0.0 ? Double.doubleToLongBits(this.rawUsageHours) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.usage != null ? this.usage.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.usageType != null ? this.usageType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UsageRecord{id=" + this.id + ", description='" + this.description + '\'' + ", accountId=" + this.accountId + ", accountName='" + this.accountName + '\'' + ", domainId=" + this.domainId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", assignDate=" + this.assignDate + ", releaseDate=" + this.releaseDate + ", zoneId=" + this.zoneId + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", templateId=" + this.templateId + ", ipAddress='" + this.ipAddress + '\'' + ", isSourceNAT=" + this.isSourceNAT + ", rawUsageHours=" + this.rawUsageHours + ", usage='" + this.usage + '\'' + ", type='" + this.type + '\'' + ", usageType=" + (Object)((Object)this.usageType) + '}';
    }

    @Override
    public int compareTo(UsageRecord other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private String description;
        private long accountId;
        private String accountName;
        private long domainId;
        private Date startDate;
        private Date endDate;
        private Date assignDate;
        private long releaseDate;
        private long zoneId;
        private long virtualMachineId;
        private String virtualMachineName;
        private long serviceOfferingId;
        private long templateId;
        private String ipAddress;
        private boolean isSourceNAT;
        private double rawUsageHours;
        private String usage;
        private String type;
        private UsageType usageType;

        private Builder() {
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder assignDate(Date assignDate) {
            this.assignDate = assignDate;
            return this;
        }

        public Builder releaseDate(long releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder virtualMachineId(long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder serviceOfferingId(long serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder templateId(long templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder surceNAT(boolean sourceNAT) {
            this.isSourceNAT = sourceNAT;
            return this;
        }

        public Builder rawUsageHours(double rawUsageHours) {
            this.rawUsageHours = rawUsageHours;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder usageType(UsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        public UsageRecord build() {
            return new UsageRecord(this.id, this.description, this.accountId, this.accountName, this.domainId, this.startDate, this.endDate, this.assignDate, this.releaseDate, this.zoneId, this.virtualMachineId, this.virtualMachineName, this.serviceOfferingId, this.templateId, this.ipAddress, this.isSourceNAT, this.rawUsageHours, this.usage, this.type, this.usageType);
        }
    }

    public static enum UsageType {
        RUNNING_VM(1),
        ALLOCATED_VM(2),
        IP_ADDRESS(3),
        NETWORK_BYTES_SENT(4),
        NETWORK_BYTES_RECEIVED(5),
        VOLUME(6),
        TEMPLATE(7),
        ISO(8),
        SNAPSHOT(9),
        SECURITY_GROUP(10),
        LOAD_BALANCER_POLICY(11),
        PORT_FORWARDING_RULE(12),
        NETWORK_OFFERING(13),
        VPN_USERS(14),
        UNRECOGNIZED(0);

        private int code;
        private static final Map<Integer, UsageType> INDEX;

        private UsageType(int code) {
            this.code = code;
        }

        public String toString() {
            return "" + this.code;
        }

        public static UsageType fromValue(String usageType) {
            Integer code = new Integer(Preconditions.checkNotNull(usageType, "usageType"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex(ImmutableSet.copyOf(UsageType.values()), new Function<UsageType, Integer>(){

                @Override
                public Integer apply(UsageType input) {
                    return input.code;
                }
            });
        }
    }
}

