/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.SecurityGroup;

public class VirtualMachine
implements Comparable<VirtualMachine> {
    private long id;
    private String account;
    @SerializedName(value="cpunumber")
    private long cpuCount;
    @SerializedName(value="cpuspeed")
    private long cpuSpeed;
    @SerializedName(value="cpuused")
    private String cpuUsed;
    @SerializedName(value="displayname")
    private String displayName;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="forvirtualnetwork")
    private boolean usesVirtualNetwork;
    private String group;
    @SerializedName(value="groupid")
    private long groupId;
    @SerializedName(value="guestosid")
    private long guestOSId;
    @SerializedName(value="haenable")
    private boolean HAEnabled;
    @SerializedName(value="hostid")
    private long hostId;
    private String hostname;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="isodisplaytext")
    private String ISODisplayText;
    @SerializedName(value="isoid")
    private long ISOId;
    @SerializedName(value="isoname")
    private String ISOName;
    @SerializedName(value="jobid")
    @Nullable
    private Long jobId;
    @SerializedName(value="jobstatus")
    @Nullable
    private Integer jobStatus;
    private long memory;
    private String name;
    @SerializedName(value="networkkbsread")
    private Long networkKbsRead;
    @SerializedName(value="networkkbswrite")
    private Long networkKbsWrite;
    @Nullable
    private String password;
    @SerializedName(value="passwordenabled")
    private boolean passwordEnabled;
    @SerializedName(value="rootdeviceid")
    private long rootDeviceId;
    @SerializedName(value="rootdevicetype")
    private String rootDeviceType;
    @SerializedName(value="serviceofferingid")
    private long serviceOfferingId;
    @SerializedName(value="serviceofferingname")
    private String serviceOfferingName;
    private State state;
    @SerializedName(value="templatedisplaytext")
    private String templateDisplayText;
    @SerializedName(value="templateid")
    private long templateId;
    @SerializedName(value="templatename")
    private String templateName;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="nic")
    private Set<NIC> nics = ImmutableSet.of();
    private String hypervisor;
    @SerializedName(value="securitygroup")
    private Set<SecurityGroup> securityGroups = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public VirtualMachine(long id, String account, long cpuCount, long cpuSpeed, String cpuUsed, String displayName, Date created, String domain, long domainId, boolean usesVirtualNetwork, String group, long groupId, long guestOSId, boolean hAEnabled, long hostId, String hostname, String iPAddress, String iSODisplayText, long iSOId, String iSOName, Long jobId, Integer jobStatus, long memory, String name, Long networkKbsRead, Long networkKbsWrite, String password, boolean passwordEnabled, long rootDeviceId, String rootDeviceType, Set<SecurityGroup> securityGroups, long serviceOfferingId, String serviceOfferingName, State state, String templateDisplayText, long templateId, String templateName, long zoneId, String zoneName, Set<NIC> nics, String hypervisor) {
        Preconditions.checkArgument(Strings.isNullOrEmpty(cpuUsed) || cpuUsed.matches("^[0-9\\.]+%$"), "cpuUsed value should be a decimal number followed by %");
        this.id = id;
        this.account = account;
        this.cpuCount = cpuCount;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed != null ? cpuUsed + "" : null;
        this.displayName = displayName;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.group = group;
        this.groupId = groupId;
        this.guestOSId = guestOSId;
        this.HAEnabled = hAEnabled;
        this.hostId = hostId;
        this.hostname = hostname;
        this.IPAddress = iPAddress;
        this.ISODisplayText = iSODisplayText;
        this.ISOId = iSOId;
        this.ISOName = iSOName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.memory = memory;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.password = password;
        this.passwordEnabled = passwordEnabled;
        this.rootDeviceId = rootDeviceId;
        this.rootDeviceType = rootDeviceType;
        this.securityGroups = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(securityGroups, "securityGroups"));
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.state = state;
        this.templateDisplayText = templateDisplayText;
        this.templateId = templateId;
        this.templateName = templateName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.nics = nics;
        this.hypervisor = hypervisor;
    }

    VirtualMachine() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public long getCpuCount() {
        return this.cpuCount;
    }

    public long getCpuSpeed() {
        return this.cpuSpeed;
    }

    public float getCpuUsed() {
        return this.cpuUsed != null ? Float.parseFloat(this.cpuUsed.substring(0, this.cpuUsed.length() - 1)) : 0.0f;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    public String getGroup() {
        return this.group;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public long getGuestOSId() {
        return this.guestOSId;
    }

    public boolean isHAEnabled() {
        return this.HAEnabled;
    }

    public long getHostId() {
        return this.hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIPAddress() {
        if (this.IPAddress != null) {
            return this.IPAddress;
        }
        if (this.getNICs().size() > 0) {
            return Iterables.get(this.getNICs(), 0).getIPAddress();
        }
        return null;
    }

    public String getISODisplayText() {
        return this.ISODisplayText;
    }

    public long getISOId() {
        return this.ISOId;
    }

    public String getISOName() {
        return this.ISOName;
    }

    @Nullable
    public Long getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public long getMemory() {
        return this.memory;
    }

    public String getName() {
        return this.name;
    }

    public Long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    public Long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    public long getRootDeviceId() {
        return this.rootDeviceId;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public Set<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public long getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    public State getState() {
        return this.state;
    }

    public String getTemplateDisplayText() {
        return this.templateDisplayText;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public Set<NIC> getNICs() {
        return this.nics;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.HAEnabled ? 1231 : 1237);
        result = 31 * result + (this.IPAddress == null ? 0 : this.IPAddress.hashCode());
        result = 31 * result + (this.ISODisplayText == null ? 0 : this.ISODisplayText.hashCode());
        result = 31 * result + (int)(this.ISOId ^ this.ISOId >>> 32);
        result = 31 * result + (this.ISOName == null ? 0 : this.ISOName.hashCode());
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (int)(this.cpuCount ^ this.cpuCount >>> 32);
        result = 31 * result + (int)(this.cpuSpeed ^ this.cpuSpeed >>> 32);
        result = 31 * result + (this.cpuUsed == null ? 0 : this.cpuUsed.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (int)(this.groupId ^ this.groupId >>> 32);
        result = 31 * result + (int)(this.guestOSId ^ this.guestOSId >>> 32);
        result = 31 * result + (int)(this.hostId ^ this.hostId >>> 32);
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.hypervisor == null ? 0 : this.hypervisor.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + (this.jobStatus == null ? 0 : this.jobStatus.hashCode());
        result = 31 * result + (int)(this.memory ^ this.memory >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.networkKbsRead == null ? 0 : this.networkKbsRead.hashCode());
        result = 31 * result + (this.networkKbsWrite == null ? 0 : this.networkKbsWrite.hashCode());
        result = 31 * result + (this.nics == null ? 0 : ((Object)this.nics).hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.passwordEnabled ? 1231 : 1237);
        result = 31 * result + (int)(this.rootDeviceId ^ this.rootDeviceId >>> 32);
        result = 31 * result + (this.securityGroups == null ? 0 : ((Object)this.securityGroups).hashCode());
        result = 31 * result + (int)(this.serviceOfferingId ^ this.serviceOfferingId >>> 32);
        result = 31 * result + (this.serviceOfferingName == null ? 0 : this.serviceOfferingName.hashCode());
        result = 31 * result + (this.templateDisplayText == null ? 0 : this.templateDisplayText.hashCode());
        result = 31 * result + (int)(this.templateId ^ this.templateId >>> 32);
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        result = 31 * result + (this.usesVirtualNetwork ? 1231 : 1237);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName == null ? 0 : this.zoneName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMachine other = (VirtualMachine)obj;
        if (this.HAEnabled != other.HAEnabled) {
            return false;
        }
        if (this.IPAddress == null ? other.IPAddress != null : !this.IPAddress.equals(other.IPAddress)) {
            return false;
        }
        if (this.ISODisplayText == null ? other.ISODisplayText != null : !this.ISODisplayText.equals(other.ISODisplayText)) {
            return false;
        }
        if (this.ISOId != other.ISOId) {
            return false;
        }
        if (this.ISOName == null ? other.ISOName != null : !this.ISOName.equals(other.ISOName)) {
            return false;
        }
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.cpuCount != other.cpuCount) {
            return false;
        }
        if (this.cpuSpeed != other.cpuSpeed) {
            return false;
        }
        if (this.cpuUsed == null ? other.cpuUsed != null : !this.cpuUsed.equals(other.cpuUsed)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.groupId != other.groupId) {
            return false;
        }
        if (this.guestOSId != other.guestOSId) {
            return false;
        }
        if (this.hostId != other.hostId) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.hypervisor == null ? other.hypervisor != null : !this.hypervisor.equals(other.hypervisor)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        if (this.jobStatus == null ? other.jobStatus != null : !this.jobStatus.equals(other.jobStatus)) {
            return false;
        }
        if (this.memory != other.memory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.networkKbsRead == null ? other.networkKbsRead != null : !this.networkKbsRead.equals(other.networkKbsRead)) {
            return false;
        }
        if (this.networkKbsWrite == null ? other.networkKbsWrite != null : !this.networkKbsWrite.equals(other.networkKbsWrite)) {
            return false;
        }
        if (this.nics == null ? other.nics != null : !((Object)this.nics).equals(other.nics)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.passwordEnabled != other.passwordEnabled) {
            return false;
        }
        if (this.rootDeviceId != other.rootDeviceId) {
            return false;
        }
        if (this.securityGroups == null ? other.securityGroups != null : !((Object)this.securityGroups).equals(other.securityGroups)) {
            return false;
        }
        if (this.serviceOfferingId != other.serviceOfferingId) {
            return false;
        }
        if (this.serviceOfferingName == null ? other.serviceOfferingName != null : !this.serviceOfferingName.equals(other.serviceOfferingName)) {
            return false;
        }
        if (this.templateDisplayText == null ? other.templateDisplayText != null : !this.templateDisplayText.equals(other.templateDisplayText)) {
            return false;
        }
        if (this.templateId != other.templateId) {
            return false;
        }
        if (this.templateName == null ? other.templateName != null : !this.templateName.equals(other.templateName)) {
            return false;
        }
        if (this.usesVirtualNetwork != other.usesVirtualNetwork) {
            return false;
        }
        if (this.zoneId != other.zoneId) {
            return false;
        }
        return !(this.zoneName == null ? other.zoneName != null : !this.zoneName.equals(other.zoneName));
    }

    public String toString() {
        return "VirtualMachine{id=" + this.id + ", account='" + this.account + '\'' + ", cpuCount=" + this.cpuCount + ", cpuSpeed=" + this.cpuSpeed + ", cpuUsed='" + this.cpuUsed + '\'' + ", displayName='" + this.displayName + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", usesVirtualNetwork=" + this.usesVirtualNetwork + ", group='" + this.group + '\'' + ", groupId=" + this.groupId + ", guestOSId=" + this.guestOSId + ", HAEnabled=" + this.HAEnabled + ", hostId=" + this.hostId + ", hostname='" + this.hostname + '\'' + ", IPAddress='" + this.IPAddress + '\'' + ", ISODisplayText='" + this.ISODisplayText + '\'' + ", ISOId=" + this.ISOId + ", ISOName='" + this.ISOName + '\'' + ", jobId=" + this.jobId + ", jobStatus=" + this.jobStatus + ", memory=" + this.memory + ", name='" + this.name + '\'' + ", networkKbsRead=" + this.networkKbsRead + ", networkKbsWrite=" + this.networkKbsWrite + ", password='" + this.password + '\'' + ", passwordEnabled=" + this.passwordEnabled + ", rootDeviceId=" + this.rootDeviceId + ", rootDeviceType='" + this.rootDeviceType + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", serviceOfferingName='" + this.serviceOfferingName + '\'' + ", state=" + (Object)((Object)this.state) + ", templateDisplayText='" + this.templateDisplayText + '\'' + ", templateId=" + this.templateId + ", templateName='" + this.templateName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", nics=" + this.nics + ", hypervisor='" + this.hypervisor + '\'' + ", securityGroups=" + this.securityGroups + '}';
    }

    @Override
    public int compareTo(VirtualMachine arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        DESTROYED,
        EXPUNGING,
        MIGRATING,
        ERROR,
        UNKNOWN,
        SHUTDOWNED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String account;
        private long cpuCount;
        private long cpuSpeed;
        private String cpuUsed;
        private String displayName;
        private Date created;
        private String domain;
        private long domainId;
        private boolean usesVirtualNetwork;
        private String group;
        private long groupId;
        private long guestOSId;
        private boolean HAEnabled;
        private long hostId;
        private String hostname;
        private String IPAddress;
        private String ISODisplayText;
        private long ISOId;
        private String ISOName;
        private Long jobId;
        private Integer jobStatus;
        private long memory;
        private String name;
        private Long networkKbsRead;
        private Long networkKbsWrite;
        private String password;
        private boolean passwordEnabled;
        private long rootDeviceId;
        private String rootDeviceType;
        private long serviceOfferingId;
        private String serviceOfferingName;
        private State state;
        private String templateDisplayText;
        private long templateId;
        private String templateName;
        private long zoneId;
        private String zoneName;
        private Set<NIC> nics = ImmutableSet.of();
        private String hypervisor;
        private Set<SecurityGroup> securityGroups = ImmutableSet.of();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder cpuCount(long cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public Builder cpuSpeed(long cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder groupId(long groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder guestOSId(long guestOSId) {
            this.guestOSId = guestOSId;
            return this;
        }

        public Builder isHAEnabled(boolean HAEnabled) {
            this.HAEnabled = HAEnabled;
            return this;
        }

        public Builder hostId(long hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder ISODisplayText(String ISODisplayText) {
            this.ISODisplayText = ISODisplayText;
            return this;
        }

        public Builder ISOId(long ISOId) {
            this.ISOId = ISOId;
            return this;
        }

        public Builder ISOName(String ISOName) {
            this.ISOName = ISOName;
            return this;
        }

        public Builder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(int jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder memory(long memory) {
            this.memory = memory;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkKbsRead(Long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this;
        }

        public Builder networkKbsWrite(Long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder rootDeviceId(long rootDeviceId) {
            this.rootDeviceId = rootDeviceId;
            return this;
        }

        public Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        public Builder serviceOfferingId(long serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder templateDisplayText(String templateDisplayText) {
            this.templateDisplayText = templateDisplayText;
            return this;
        }

        public Builder templateId(long templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder nics(Iterable<NIC> nics) {
            this.nics = ImmutableSet.copyOf(Preconditions.checkNotNull(nics, "nics"));
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder securityGroups(Set<SecurityGroup> securityGroups) {
            this.securityGroups = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(securityGroups, "securityGroups"));
            return this;
        }

        public VirtualMachine build() {
            return new VirtualMachine(this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.rootDeviceId, this.rootDeviceType, this.securityGroups, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor);
        }
    }
}

