/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.DiskOffering;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.features.OfferingAsyncClient;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.CreateDiskOfferingOptions;
import org.jclouds.cloudstack.options.CreateServiceOfferingOptions;
import org.jclouds.cloudstack.options.UpdateDiskOfferingOptions;
import org.jclouds.cloudstack.options.UpdateNetworkOfferingOptions;
import org.jclouds.cloudstack.options.UpdateServiceOfferingOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalOfferingAsyncClient
extends OfferingAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"createServiceOffering"})
    @SelectJson(value="serviceoffering")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ServiceOffering> createServiceOffering(@QueryParam(value="name") String var1, @QueryParam(value="displaytext") String var2, @QueryParam(value="cpunumber") int var3, @QueryParam(value="cpuspeed") int var4, @QueryParam(value="memory") int var5, CreateServiceOfferingOptions ... var6);

    @GET
    @QueryParams(keys={"command"}, values={"updateServiceOffering"})
    @SelectJson(value="serviceoffering")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ServiceOffering> updateServiceOffering(@QueryParam(value="id") long var1, UpdateServiceOfferingOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteServiceOffering"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteServiceOffering(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createDiskOffering"})
    @SelectJson(value="diskoffering")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<DiskOffering> createDiskOffering(@QueryParam(value="name") String var1, @QueryParam(value="displaytext") String var2, CreateDiskOfferingOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"updateDiskOffering"})
    @SelectJson(value="diskoffering")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<DiskOffering> updateDiskOffering(@QueryParam(value="id") long var1, UpdateDiskOfferingOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteDiskOffering"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteDiskOffering(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"updateNetworkOffering"})
    @SelectJson(value="networkoffering")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<NetworkOffering> updateNetworkOffering(@QueryParam(value="id") long var1, UpdateNetworkOfferingOptions ... var3);
}

