/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.CreateLoadBalancerRuleOptions;
import org.jclouds.cloudstack.options.ListLoadBalancerRulesOptions;
import org.jclouds.cloudstack.options.UpdateLoadBalancerRuleOptions;
import org.jclouds.functions.JoinOnComma;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface LoadBalancerAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listLoadBalancerRules"})
    @SelectJson(value="loadbalancerrule")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<LoadBalancerRule>> listLoadBalancerRules(ListLoadBalancerRulesOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"listLoadBalancerRules"})
    @SelectJson(value="loadbalancerrule")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<LoadBalancerRule> getLoadBalancerRule(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createLoadBalancerRule"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> createLoadBalancerRuleForPublicIP(@QueryParam(value="publicipid") long var1, @QueryParam(value="algorithm") LoadBalancerRule.Algorithm var3, @QueryParam(value="name") String var4, @QueryParam(value="privateport") int var5, @QueryParam(value="publicport") int var6, CreateLoadBalancerRuleOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"updateLoadBalancerRule"})
    @SelectJson(value="loadbalancerrule")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<LoadBalancerRule> updateLoadBalancerRule(@QueryParam(value="id") long var1, UpdateLoadBalancerRuleOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"deleteLoadBalancerRule"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Long> deleteLoadBalancerRule(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"assignToLoadBalancerRule"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> assignVirtualMachinesToLoadBalancerRule(@QueryParam(value="id") long var1, @QueryParam(value="virtualmachineids") @ParamParser(value=JoinOnComma.class) Iterable<Long> var3);

    @GET
    @QueryParams(keys={"command"}, values={"assignToLoadBalancerRule"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> assignVirtualMachinesToLoadBalancerRule(@QueryParam(value="id") long var1, long ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"removeFromLoadBalancerRule"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> removeVirtualMachinesFromLoadBalancerRule(@QueryParam(value="id") long var1, @QueryParam(value="virtualmachineids") @ParamParser(value=JoinOnComma.class) Iterable<Long> var3);

    @GET
    @QueryParams(keys={"command"}, values={"removeFromLoadBalancerRule"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> removeVirtualMachinesFromLoadBalancerRule(@QueryParam(value="id") long var1, long ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"listLoadBalancerRuleInstances"})
    @SelectJson(value="loadbalancerruleinstance")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VirtualMachine>> listVirtualMachinesAssignedToLoadBalancerRule(@QueryParam(value="id") long var1);
}

