/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.util.Strings2;

@Singleton
public class QuerySigner
implements HttpRequestFilter,
RequestSigner {
    private final SignatureWire signatureWire;
    private final String accessKey;
    private final String secretKey;
    private final Crypto crypto;
    private final HttpUtils utils;
    private final Provider<UriBuilder> builder;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;

    @Inject
    public QuerySigner(SignatureWire signatureWire, @Named(value="jclouds.identity") String accessKey, @Named(value="jclouds.credential") String secretKey, Crypto crypto, HttpUtils utils, Provider<UriBuilder> builder) {
        this.signatureWire = signatureWire;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.crypto = crypto;
        this.utils = utils;
        this.builder = builder;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull(request, "request must be present");
        Multimap<String, String> decodedParams = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
        this.addSigningParams(decodedParams);
        String stringToSign = this.createStringToSign(request, decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature(decodedParams, signature);
        request = request.toBuilder().endpoint(this.builder.get().uri(request.getEndpoint()).replaceQuery(ModifyRequest.makeQueryLine(decodedParams, null, new char[0])).build(new Object[0])).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues("signature", ImmutableList.of(signature));
    }

    @Override
    @VisibleForTesting
    public String sign(String stringToSign) {
        String signature;
        try {
            signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(stringToSign), this.crypto.hmacSHA1(this.secretKey.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream(signature));
            }
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
        return signature;
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, String> entry : decodedParams.entries()) {
            builder.add(entry.getKey() + "=" + Strings2.urlEncode(entry.getValue(), new char[0]));
        }
        String stringToSign = Joiner.on('&').join(builder.build()).toLowerCase();
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(stringToSign);
        }
        return stringToSign;
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues("apiKey", ImmutableList.of(this.accessKey));
        params.removeAll("signature");
    }

    @Override
    public String createStringToSign(HttpRequest input) {
        Multimap<String, String> decodedParams = ModifyRequest.parseQueryToMap(input.getEndpoint().getQuery());
        this.addSigningParams(decodedParams);
        return this.createStringToSign(input, decodedParams);
    }
}

