/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseEventTypesFromHttpResponse
implements Function<HttpResponse, Set<String>> {
    private final ParseFirstJsonValueNamed<Set<EventType>> parser;

    @Inject
    public ParseEventTypesFromHttpResponse(GsonWrapper gsonWrapper) {
        this.parser = new ParseFirstJsonValueNamed<Set<EventType>>(Preconditions.checkNotNull(gsonWrapper, "gsonWrapper"), new TypeLiteral<Set<EventType>>(){}, "eventtype");
    }

    @Override
    public Set<String> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Set<EventType> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EventType entry : toParse) {
            builder.add(entry.name);
        }
        return builder.build();
    }

    private static class EventType {
        private String name;

        private EventType() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }
    }
}

