/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudstack.functions.ParseIdToNameFromHttpResponse;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseIdToNameEntryFromHttpResponse
implements Function<HttpResponse, Map.Entry<Long, String>> {
    private final ParseIdToNameFromHttpResponse parser;

    @Inject
    public ParseIdToNameEntryFromHttpResponse(ParseIdToNameFromHttpResponse parser) {
        this.parser = Preconditions.checkNotNull(parser, "parser");
    }

    @Override
    public Map.Entry<Long, String> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Map<Long, String> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        return Iterables.getFirst(toParse.entrySet(), null);
    }
}

