/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseIdToNameFromHttpResponse
implements Function<HttpResponse, Map<Long, String>> {
    private final ParseFirstJsonValueNamed<Set<IdName>> parser;

    @Inject
    public ParseIdToNameFromHttpResponse(GsonWrapper gsonWrapper) {
        this.parser = new ParseFirstJsonValueNamed<Set<IdName>>(Preconditions.checkNotNull(gsonWrapper, "gsonWrapper"), new TypeLiteral<Set<IdName>>(){}, "oscategory");
    }

    @Override
    public Map<Long, String> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Set<IdName> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        ImmutableSortedMap.Builder<Long, String> builder = ImmutableSortedMap.naturalOrder();
        for (IdName entry : toParse) {
            ((ImmutableMap.Builder)builder).put(entry.id, entry.name);
        }
        return ((ImmutableMap.Builder)builder).build();
    }

    private static class IdName {
        private long id;
        private String name;

        private IdName() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdName other = (IdName)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

