/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.handlers;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.IOException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class CloudStackErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_12;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 400: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, httpResponseException);
                    break;
                }
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(message, httpResponseException);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, httpResponseException);
                    break;
                }
                case 405: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, httpResponseException);
                    break;
                }
                case 409: 
                case 431: {
                    if (command.getCurrentRequest().getRequestLine().indexOf("delete") != -1 && message.indexOf("does not exist") != -1) {
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, httpResponseException);
                        break;
                    }
                    IllegalStateException illegalStateException = new IllegalStateException(message, httpResponseException);
                    break;
                }
                case 537: {
                    IllegalStateException illegalStateException = new IllegalStateException(message, httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (response.getPayload() != null) {
                Closeables.closeQuietly(response.getPayload().getInput());
            }
            command.setException(httpResponseException);
            throw throwable;
        }
        if (response.getPayload() != null) {
            Closeables.closeQuietly(response.getPayload().getInput());
        }
        command.setException((Exception)var4_12);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            String string = Strings2.toStringAndClose(response.getPayload().getInput());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                response.getPayload().getInput().close();
            }
            catch (IOException e) {
                Throwables.propagate(e);
            }
        }
    }
}

