/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AccountInDomainOptions
extends BaseHttpRequestOptions {
    public static final AccountInDomainOptions NONE = new AccountInDomainOptions();

    public AccountInDomainOptions accountInDomain(String account, long domain) {
        this.queryParameters.replaceValues("account", ImmutableSet.of(account));
        this.queryParameters.replaceValues("domainid", ImmutableSet.of(domain + ""));
        return this;
    }

    public AccountInDomainOptions domainId(long domainId) {
        this.queryParameters.replaceValues("domainid", ImmutableSet.of(domainId + ""));
        return this;
    }

    public static class Builder {
        public static AccountInDomainOptions accountInDomain(String account, long domain) {
            AccountInDomainOptions options = new AccountInDomainOptions();
            return options.accountInDomain(account, domain);
        }

        public static AccountInDomainOptions domainId(long domainId) {
            AccountInDomainOptions options = new AccountInDomainOptions();
            return options.domainId(domainId);
        }
    }
}

