/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.options.ListHostsOptions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListClustersOptions
extends BaseHttpRequestOptions {
    public static final ListHostsOptions NONE = new ListHostsOptions();

    public ListClustersOptions allocationState(Host.AllocationState allocationState) {
        this.queryParameters.replaceValues("allocationstate", ImmutableSet.of(allocationState.toString()));
        return this;
    }

    public ListClustersOptions clusterType(Host.ClusterType clusterType) {
        this.queryParameters.replaceValues("clustertype", ImmutableSet.of(clusterType.toString()));
        return this;
    }

    public ListClustersOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues("hypervisor", ImmutableSet.of(hypervisor));
        return this;
    }

    public ListClustersOptions id(long id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListClustersOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListClustersOptions managedState(Cluster.ManagedState managedState) {
        this.queryParameters.replaceValues("managedstate", ImmutableSet.of(managedState.toString()));
        return this;
    }

    public ListClustersOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListClustersOptions podId(long podId) {
        this.queryParameters.replaceValues("podid", ImmutableSet.of(podId + ""));
        return this;
    }

    public ListClustersOptions zoneId(long zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    public static class Builder {
        public static ListClustersOptions allocationState(Host.AllocationState allocationState) {
            return new ListClustersOptions().allocationState(allocationState);
        }

        public static ListClustersOptions clusterType(Host.ClusterType clusterType) {
            return new ListClustersOptions().clusterType(clusterType);
        }

        public static ListClustersOptions hypervisor(String hypervisor) {
            return new ListClustersOptions().hypervisor(hypervisor);
        }

        public static ListClustersOptions id(long id) {
            return new ListClustersOptions().id(id);
        }

        public static ListClustersOptions keyword(String keyword) {
            return new ListClustersOptions().keyword(keyword);
        }

        public static ListClustersOptions managedState(Cluster.ManagedState managedState) {
            return new ListClustersOptions().managedState(managedState);
        }

        public static ListClustersOptions name(String name) {
            return new ListClustersOptions().name(name);
        }

        public static ListClustersOptions podId(long podId) {
            return new ListClustersOptions().podId(podId);
        }

        public static ListClustersOptions zoneId(long zoneId) {
            return new ListClustersOptions().zoneId(zoneId);
        }
    }
}

