/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListUsersOptions
extends AccountInDomainOptions {
    public static final ListUsersOptions NONE = new ListUsersOptions();

    public ListUsersOptions id(long id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListUsersOptions userName(String userName) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(userName));
        return this;
    }

    public ListUsersOptions state(User.State state) {
        this.queryParameters.replaceValues("state", ImmutableSet.of(state.toString()));
        return this;
    }

    public ListUsersOptions accountType(String accountType) {
        this.queryParameters.replaceValues("accounttype", ImmutableSet.of(accountType));
        return this;
    }

    public ListUsersOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListUsersOptions page(long page) {
        this.queryParameters.replaceValues("page", ImmutableSet.of(page + ""));
        return this;
    }

    public ListUsersOptions pageSize(long pageSize) {
        this.queryParameters.replaceValues("pagesize", ImmutableSet.of(pageSize + ""));
        return this;
    }

    @Override
    public ListUsersOptions accountInDomain(String account, long domain) {
        return (ListUsersOptions)ListUsersOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListUsersOptions domainId(long domainId) {
        return (ListUsersOptions)ListUsersOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListUsersOptions id(long id) {
            ListUsersOptions options = new ListUsersOptions();
            return options.id(id);
        }

        public static ListUsersOptions userName(String name) {
            ListUsersOptions options = new ListUsersOptions();
            return options.userName(name);
        }

        public static ListUsersOptions state(User.State state) {
            ListUsersOptions options = new ListUsersOptions();
            return options.state(state);
        }

        public static ListUsersOptions accountType(String accountType) {
            ListUsersOptions options = new ListUsersOptions();
            return options.accountType(accountType);
        }

        public static ListUsersOptions keyword(String keyword) {
            ListUsersOptions options = new ListUsersOptions();
            return options.keyword(keyword);
        }

        public static ListUsersOptions page(long page) {
            ListUsersOptions options = new ListUsersOptions();
            return options.page(page);
        }

        public static ListUsersOptions pageSize(long pageSize) {
            ListUsersOptions options = new ListUsersOptions();
            return options.pageSize(pageSize);
        }

        public static ListUsersOptions accountInDomain(String account, long domain) {
            ListUsersOptions options = new ListUsersOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListUsersOptions domainId(long id) {
            ListUsersOptions options = new ListUsersOptions();
            return options.domainId(id);
        }
    }
}

