/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class UpdateHostOptions
extends BaseHttpRequestOptions {
    public static final UpdateHostOptions NONE = new UpdateHostOptions();

    public UpdateHostOptions allocationState(Host.AllocationState allocationState) {
        this.queryParameters.replaceValues("allocationstate", ImmutableSet.of(allocationState.toString()));
        return this;
    }

    public UpdateHostOptions hostTags(Set<String> hostTags) {
        this.queryParameters.replaceValues("hosttags", ImmutableSet.of(Joiner.on(',').join(hostTags)));
        return this;
    }

    public UpdateHostOptions osCategoryId(long osCategoryId) {
        this.queryParameters.replaceValues("oscategoryid", ImmutableSet.of(osCategoryId + ""));
        return this;
    }

    public static class Builder {
        public static UpdateHostOptions allocationState(Host.AllocationState allocationState) {
            return new UpdateHostOptions().allocationState(allocationState);
        }

        public static UpdateHostOptions hostTags(Set<String> hostTags) {
            return new UpdateHostOptions().hostTags(hostTags);
        }

        public static UpdateHostOptions osCategoryId(long osCategoryId) {
            return new UpdateHostOptions().osCategoryId(osCategoryId);
        }
    }
}

