/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudstack.AsyncJobException;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.logging.Logger;

@Singleton
public class JobComplete
implements Predicate<Long> {
    private final CloudStackClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public JobComplete(CloudStackClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(Long jobId) {
        this.logger.trace(">> looking for status on job %s", Preconditions.checkNotNull(jobId, "jobId"));
        AsyncJob<?> job = this.refresh(jobId);
        if (job == null) {
            return false;
        }
        this.logger.trace("%s: looking for job status %s: currently: %s", new Object[]{job.getId(), 1, job.getStatus()});
        if (job.hasFailed()) {
            throw new AsyncJobException(String.format("job %s failed with exception %s", job.toString(), job.getError().toString()));
        }
        return job.hasSucceed();
    }

    private AsyncJob<?> refresh(Long jobId) {
        return this.client.getAsyncJobClient().getAsyncJob(jobId);
    }
}

