/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;

public class NetworkPredicates {
    public static Predicate<NetworkService> supportsStaticNAT = Predicates.and(new NetworkServiceNamed("Firewall"), new CapabilitiesInclude("StaticNat"));
    public static Predicate<NetworkService> supportsPortForwarding = Predicates.and(new NetworkServiceNamed("Firewall"), new CapabilitiesInclude("PortForwarding"));
    public static Predicate<NetworkService> isLoadBalancerService = new NetworkServiceNamed("Lb");
    public static Predicate<GuestIPType> isVirtualNetwork = new GuestIPTypeIs(GuestIPType.VIRTUAL);

    public static Predicate<Network> supportsStaticNAT() {
        return HasFirewallServiceWhichSupportsStaticNAT.INSTANCE;
    }

    public static Predicate<Network> supportsPortForwarding() {
        return HasFirewallServiceWhichSupportsPortForwarding.INSTANCE;
    }

    public static Predicate<Network> hasLoadBalancerService() {
        return HasLoadBalancerService.INSTANCE;
    }

    public static Predicate<Network> isVirtualNetwork() {
        return IsVirtualNetwork.INSTANCE;
    }

    public static Predicate<Network> defaultNetworkInZone(long zoneId) {
        return new DefaultNetworkInZone(zoneId);
    }

    public static Predicate<Network> any() {
        return Predicates.alwaysTrue();
    }

    public static class CapabilitiesInclude
    implements Predicate<NetworkService> {
        private final String capability;

        public CapabilitiesInclude(String capability) {
            this.capability = Preconditions.checkNotNull(capability, "capability");
        }

        @Override
        public boolean apply(NetworkService input) {
            return "true".equals(input.getCapabilities().get(this.capability));
        }

        public String toString() {
            return "capabilitiesInclude(" + this.capability + ")";
        }
    }

    public static class GuestIPTypeIs
    implements Predicate<GuestIPType> {
        private final GuestIPType guestIPType;

        public GuestIPTypeIs(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
        }

        @Override
        public boolean apply(@Nullable GuestIPType guestIPType) {
            return guestIPType == this.guestIPType;
        }

        public String toString() {
            return "guestIPTypeIs(" + (Object)((Object)this.guestIPType) + ')';
        }
    }

    public static class NetworkServiceNamed
    implements Predicate<NetworkService> {
        private final String name;

        public NetworkServiceNamed(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
        }

        @Override
        public boolean apply(NetworkService input) {
            return this.name.equals(Preconditions.checkNotNull(input, "networkService").getName());
        }

        public String toString() {
            return "networkServiceNamed(" + this.name + ")";
        }
    }

    private static class DefaultNetworkInZone
    implements Predicate<Network> {
        private final long zoneId;

        public DefaultNetworkInZone(long zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public boolean apply(Network network) {
            return network.getZoneId() == this.zoneId && network.isDefault();
        }
    }

    public static enum IsVirtualNetwork implements Predicate<Network>
    {
        INSTANCE;


        @Override
        public boolean apply(Network arg0) {
            boolean network = isVirtualNetwork.apply(Preconditions.checkNotNull(arg0, "network").getGuestIPType());
            return network;
        }

        public String toString() {
            return isVirtualNetwork.toString();
        }
    }

    public static enum HasLoadBalancerService implements Predicate<Network>
    {
        INSTANCE;


        @Override
        public boolean apply(Network arg0) {
            return Iterables.any(Preconditions.checkNotNull(arg0, "network").getServices(), isLoadBalancerService);
        }

        public String toString() {
            return isLoadBalancerService.toString();
        }
    }

    public static enum HasFirewallServiceWhichSupportsPortForwarding implements Predicate<Network>
    {
        INSTANCE;


        @Override
        public boolean apply(Network arg0) {
            return Iterables.any(Preconditions.checkNotNull(arg0, "network").getServices(), supportsPortForwarding);
        }

        public String toString() {
            return supportsPortForwarding.toString();
        }
    }

    public static enum HasFirewallServiceWhichSupportsStaticNAT implements Predicate<Network>
    {
        INSTANCE;


        @Override
        public boolean apply(Network arg0) {
            return Iterables.any(Preconditions.checkNotNull(arg0, "network").getServices(), supportsStaticNAT);
        }

        public String toString() {
            return supportsStaticNAT.toString();
        }
    }
}

