/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.options.ListOSTypesOptions;

@Singleton
public class OSCategoryIn
implements Function<Set<String>, Predicate<Template>> {
    private final Supplier<Map<Long, String>> categoriesSupplier;
    private final Supplier<Set<OSType>> osTypesSupplier;

    @Inject
    public OSCategoryIn(CloudStackClient client) {
        this(Suppliers.ofInstance(Preconditions.checkNotNull(client, "client").getGuestOSClient().listOSCategories()), Suppliers.ofInstance(client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[0])));
    }

    public OSCategoryIn(Supplier<Map<Long, String>> categoriesSupplier, Supplier<Set<OSType>> osTypesSupplier) {
        this.categoriesSupplier = Preconditions.checkNotNull(categoriesSupplier, "categoriesSupplier");
        this.osTypesSupplier = Preconditions.checkNotNull(osTypesSupplier, "osTypesSupplier");
    }

    @Override
    public Predicate<Template> apply(final Set<String> acceptableCategories) {
        final Map<Long, String> categories = this.categoriesSupplier.get();
        final Set<Long> acceptableOSTypeIds = Maps.filterValues(Maps.transformValues(Maps.uniqueIndex((Iterable)this.osTypesSupplier.get(), new Function<OSType, Long>(){

            @Override
            public Long apply(OSType input) {
                return input.getId();
            }
        }), new Function<OSType, String>(){

            @Override
            public String apply(OSType input) {
                return (String)categories.get(input.getOSCategoryId());
            }
        }), Predicates.in(acceptableCategories)).keySet();
        return new Predicate<Template>(){

            @Override
            public boolean apply(Template input) {
                return Predicates.in(acceptableOSTypeIds).apply(input.getOSTypeId());
            }

            public String toString() {
                return "OSCategoryIn(" + acceptableCategories + ")";
            }
        };
    }
}

