/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.jclouds.cloudstack.domain.PublicIPAddress;

public class PublicIPAddressPredicates {
    public static Predicate<PublicIPAddress> available() {
        return Available.INSTANCE;
    }

    public static Predicate<PublicIPAddress> associatedWithNetwork(long networkId) {
        return new AssociatedWithNetwork(networkId);
    }

    public static Predicate<PublicIPAddress> any() {
        return Predicates.alwaysTrue();
    }

    public static enum Available implements Predicate<PublicIPAddress>
    {
        INSTANCE;


        @Override
        public boolean apply(PublicIPAddress arg0) {
            return !Preconditions.checkNotNull(arg0, "ipaddress").isSourceNAT() && !arg0.isStaticNAT() && arg0.getVirtualMachineId() <= 0L && arg0.getState() == PublicIPAddress.State.ALLOCATED;
        }

        public String toString() {
            return "available()";
        }
    }

    public static final class AssociatedWithNetwork
    implements Predicate<PublicIPAddress> {
        private final long networkId;

        public AssociatedWithNetwork(long networkId) {
            this.networkId = networkId;
        }

        @Override
        public boolean apply(PublicIPAddress input) {
            return Preconditions.checkNotNull(input, "ipaddress").getAssociatedNetworkId() == this.networkId;
        }

        public String toString() {
            return "associatedWithNetwork(" + this.networkId + ")";
        }
    }
}

