/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.cloudstack.domain.Zone;

public class ZoneIdToZoneSupplier
implements Supplier<LoadingCache<Long, Zone>> {
    private final LoadingCache<Long, Zone> cache;

    @Inject
    public ZoneIdToZoneSupplier(CacheLoader<Long, Zone> zoneIdToZone, @Named(value="jclouds.session-interval") long expirationSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expirationSecs, TimeUnit.SECONDS).build(zoneIdToZone);
    }

    @Override
    public LoadingCache<Long, Zone> get() {
        return this.cache;
    }
}

