/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.base.Preconditions;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetMetricStatisticsOptions
extends BaseHttpRequestOptions {
    public static final GetMetricStatisticsOptions NONE = new GetMetricStatisticsOptions();

    public GetMetricStatisticsOptions instanceId(String instanceId) {
        String[] parts = AWSUtils.parseHandle(instanceId);
        this.formParameters.put("Dimensions.member.1.Name", "InstanceId");
        this.formParameters.put("Dimensions.member.1.Value", Preconditions.checkNotNull(parts[1]));
        return this;
    }

    public GetMetricStatisticsOptions unit(Unit unit) {
        this.formParameters.put("Unit", unit.toString());
        return this;
    }

    public static class Builder {
        public static GetMetricStatisticsOptions instanceId(String instanceId) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.instanceId(instanceId);
        }

        public static GetMetricStatisticsOptions unit(Unit unit) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.unit(unit);
        }
    }
}

