/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.logging.Logger;

@Singleton
public abstract class FindResourceInSet<F, T>
implements Function<F, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<Set<? extends T>> set;

    @Inject
    public FindResourceInSet(@Memoized Supplier<Set<? extends T>> set) {
        this.set = Preconditions.checkNotNull(set, "set");
    }

    public abstract boolean matches(F var1, T var2);

    @Override
    public T apply(final F from) {
        try {
            return Iterables.find((Iterable)this.set.get(), new Predicate<T>(){

                @Override
                public boolean apply(T input) {
                    return FindResourceInSet.this.matches(from, input);
                }
            });
        }
        catch (NoSuchElementException e) {
            this.logger.trace("could not find a match in set for %s", from);
            return null;
        }
    }
}

