/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;

public class TransformingSetSupplier<F, T>
implements Supplier<Set<? extends T>> {
    private final Supplier<Iterable<F>> backingSupplier;
    private final Function<F, T> converter;

    public TransformingSetSupplier(Supplier<Iterable<F>> backingSupplier, Function<F, T> converter) {
        this.backingSupplier = Preconditions.checkNotNull(backingSupplier, "backingSupplier");
        this.converter = Preconditions.checkNotNull(converter, "converter");
    }

    @Override
    public Set<? extends T> get() {
        return ImmutableSet.copyOf(Iterables.filter(Iterables.transform(Iterables.filter(this.backingSupplier.get(), Predicates.notNull()), this.converter), Predicates.notNull()));
    }
}

