/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.ImplementedBy;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.scriptbuilder.domain.Statement;

@ImplementedBy(value=BaseComputeService.class)
public interface ComputeService {
    public ComputeServiceContext getContext();

    public TemplateBuilder templateBuilder();

    public TemplateOptions templateOptions();

    public Set<? extends Hardware> listHardwareProfiles();

    public Set<? extends Image> listImages();

    public Set<? extends ComputeMetadata> listNodes();

    public Set<? extends Location> listAssignableLocations();

    public Set<? extends NodeMetadata> createNodesInGroup(String var1, int var2, Template var3) throws RunNodesException;

    public Set<? extends NodeMetadata> createNodesInGroup(String var1, int var2, TemplateOptions var3) throws RunNodesException;

    public Set<? extends NodeMetadata> createNodesInGroup(String var1, int var2) throws RunNodesException;

    public void resumeNode(String var1);

    public void resumeNodesMatching(Predicate<NodeMetadata> var1);

    public void suspendNode(String var1);

    public void suspendNodesMatching(Predicate<NodeMetadata> var1);

    public void destroyNode(String var1);

    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> var1);

    public void rebootNode(String var1);

    public void rebootNodesMatching(Predicate<NodeMetadata> var1);

    public NodeMetadata getNodeMetadata(String var1);

    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> var1);

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> var1, String var2) throws RunScriptOnNodesException;

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> var1, Statement var2) throws RunScriptOnNodesException;

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> var1, String var2, RunScriptOptions var3) throws RunScriptOnNodesException;

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> var1, Statement var2, RunScriptOptions var3) throws RunScriptOnNodesException;

    public ExecResponse runScriptOnNode(String var1, Statement var2, RunScriptOptions var3);

    @Beta
    public ListenableFuture<ExecResponse> submitScriptOnNode(String var1, Statement var2, RunScriptOptions var3);

    public ExecResponse runScriptOnNode(String var1, Statement var2);

    public ExecResponse runScriptOnNode(String var1, String var2, RunScriptOptions var3);

    public ExecResponse runScriptOnNode(String var1, String var2);
}

