/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.ResolvesImages;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.rest.RestContextBuilder;

public abstract class ComputeServiceContextBuilder<S, A>
extends RestContextBuilder<S, A> {
    public ComputeServiceContextBuilder(Class<S> syncClientType, Class<A> asyncClientType) {
        this(syncClientType, asyncClientType, new Properties());
    }

    public ComputeServiceContextBuilder(Class<S> syncClientType, Class<A> asyncClientType, Properties properties) {
        super(syncClientType, asyncClientType, properties);
    }

    @Override
    public Injector buildInjector() {
        this.addImageResolutionModuleIfNotPresent();
        return super.buildInjector();
    }

    @Override
    public ComputeServiceContextBuilder<S, A> withModules(Iterable<Module> modules) {
        return (ComputeServiceContextBuilder)super.withModules(modules);
    }

    public ComputeServiceContext buildComputeServiceContext() {
        return (ComputeServiceContext)this.buildInjector().getInstance(Key.get(Types.newParameterizedType(ComputeServiceContextImpl.class, new Type[]{this.syncClientType, this.asyncClientType})));
    }

    protected void addImageResolutionModuleIfNotPresent() {
        if (!Iterables.any(this.modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ResolvesImages.class);
            }
        })) {
            this.addImageResolutionModule();
        }
    }

    protected void addImageResolutionModule() {
    }
}

