/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextBuilder;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.util.Throwables2;

public class ComputeServiceContextFactory {
    private final RestContextFactory contextFactory;

    public ComputeServiceContextFactory() {
        this(new RestContextFactory());
    }

    public ComputeServiceContextFactory(Properties properties) {
        this(new RestContextFactory(properties));
    }

    public ComputeServiceContextFactory(RestContextFactory restContextFactory) {
        this.contextFactory = restContextFactory;
    }

    public static <S, A> ComputeServiceContext buildContextUnwrappingExceptions(ComputeServiceContextBuilder<S, A> builder) {
        try {
            return builder.buildComputeServiceContext();
        }
        catch (Exception e) {
            return (ComputeServiceContext)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public ComputeServiceContext createContext(String provider, String identity, String credential) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public ComputeServiceContext createContext(String provider, Properties overrides) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, overrides));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public ComputeServiceContext createContext(String provider, Iterable<? extends Module> modules, Properties overrides) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, modules, overrides));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public ComputeServiceContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public ComputeServiceContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules, Properties overrides) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules, overrides));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> ComputeServiceContext createContext(RestContextSpec<S, A> contextSpec) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> ComputeServiceContext createContext(RestContextSpec<S, A> contextSpec, Properties overrides) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec, overrides));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> ComputeServiceContext createContext(RestContextSpec<S, A> contextSpec, Iterable<Module> modules, Properties overrides) {
        ComputeServiceContextBuilder builder = (ComputeServiceContextBuilder)ComputeServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec, modules, overrides));
        return ComputeServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }
}

