/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jclouds.PropertiesBuilder;
import org.jclouds.compute.ComputeServiceContextBuilder;
import org.jclouds.compute.config.StandaloneComputeServiceClientModule;

public class StandaloneComputeServiceContextBuilder<D>
extends ComputeServiceContextBuilder<D, D> {
    public StandaloneComputeServiceContextBuilder(Class<D> driverClass, Properties props) {
        super(driverClass, driverClass, props);
        if (this.properties.size() == 0) {
            this.properties.putAll((Map<?, ?>)new PropertiesBuilder().build());
        }
        if (!this.properties.containsKey("jclouds.provider")) {
            this.properties.setProperty("jclouds.provider", "standalone");
        }
        if (!this.properties.containsKey("jclouds.endpoint")) {
            this.properties.setProperty("jclouds.endpoint", "standalone");
        }
        if (!this.properties.containsKey("jclouds.api-version")) {
            this.properties.setProperty("jclouds.api-version", "1");
        }
        if (!this.properties.containsKey("jclouds.identity")) {
            this.properties.setProperty("jclouds.identity", System.getProperty("user.name"));
        }
    }

    @Override
    protected void addClientModule(List<Module> modules) {
        modules.add(new StandaloneComputeServiceClientModule(this.syncClientType));
    }
}

