/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jclouds.compute.callables.BlockUntilInitScriptStatusIsZeroThenReturnOutput;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public class RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete
extends RunScriptOnNodeAsInitScriptUsingSsh {
    protected final ComputeServiceConstants.Timeouts timeouts;
    protected final BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory statusFactory;

    @Inject
    public RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory statusFactory, ComputeServiceConstants.Timeouts timeouts, Function<NodeMetadata, SshClient> sshFactory, InitScriptConfigurationForTasks initScriptConfiguration, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options) {
        super(sshFactory, initScriptConfiguration, node, script, options);
        this.statusFactory = Preconditions.checkNotNull(statusFactory, "statusFactory");
        this.timeouts = Preconditions.checkNotNull(timeouts, "timeouts");
    }

    @Override
    public ExecResponse doCall() {
        try {
            return this.future().get(this.timeouts.scriptComplete, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public BlockUntilInitScriptStatusIsZeroThenReturnOutput future() {
        ExecResponse returnVal = super.doCall();
        Preconditions.checkState(returnVal.getExitCode() == 0, String.format("task: %s had non-zero exit status: %s", this.init.getInstanceName(), returnVal));
        return this.statusFactory.create(this).init();
    }

    @Override
    public RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete init() {
        return (RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete)RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class.cast(super.init());
    }
}

