/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public class RunScriptOnNodeUsingSsh
implements RunScriptOnNode {
    public static final String MARKER = "RUN_SCRIPT_AS_ROOT_SSH";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<NodeMetadata, SshClient> sshFactory;
    protected final NodeMetadata node;
    protected final Statement statement;
    protected final boolean runAsRoot;
    protected SshClient ssh;

    @AssistedInject
    public RunScriptOnNodeUsingSsh(Function<NodeMetadata, SshClient> sshFactory, @Assisted NodeMetadata node, @Assisted Statement statement, @Assisted RunScriptOptions options) {
        this.sshFactory = Preconditions.checkNotNull(sshFactory, "sshFactory");
        this.node = Preconditions.checkNotNull(node, "node");
        this.statement = Preconditions.checkNotNull(statement, "statement");
        this.runAsRoot = options.shouldRunAsRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResponse call() {
        Preconditions.checkState(this.ssh != null, "please call init() before invoking call");
        try {
            this.ssh.connect();
            String command = this.runAsRoot ? this.execAsRoot(this.statement.render(OsFamily.UNIX)) : this.execScriptAsDefaultUser(this.statement.render(OsFamily.UNIX));
            ExecResponse returnVal = this.runCommand(command);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<< %s[%s]", this.statement, returnVal);
            } else {
                this.logger.debug("<< %s(%d)", this.statement, returnVal.getExitCode());
            }
            ExecResponse execResponse = returnVal;
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    @Override
    public RunScriptOnNode init() {
        this.ssh = this.sshFactory.apply(this.node);
        return this;
    }

    protected ExecResponse runCommand(String command) {
        this.logger.debug(">> running [%s] as %s@%s", command.replace(this.node.getCredentials().getPassword() != null ? this.node.getCredentials().getPassword() : "XXXXX", "XXXXX"), this.ssh.getUsername(), this.ssh.getHostAddress());
        ExecResponse returnVal = this.ssh.exec(command);
        return returnVal;
    }

    @VisibleForTesting
    public String execAsRoot(String command) {
        if (!this.node.getCredentials().identity.equals("root")) {
            command = this.node.getCredentials().shouldAuthenticateSudo() ? String.format("sudo -S sh <<'%s'\n%s\n%s%s\n", MARKER, this.node.getCredentials().getPassword(), command, MARKER) : String.format("sudo sh <<'%s'\n%s%s\n", MARKER, command, MARKER);
        }
        return command;
    }

    protected String execScriptAsDefaultUser(String command) {
        return command;
    }

    @Override
    public NodeMetadata getNode() {
        return this.node;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("node", this.node).add("name", this.statement).add("runAsRoot", this.runAsRoot).toString();
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

