/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.InitBuilder;
import org.jclouds.ssh.SshClient;

public class SudoAwareInitManager {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger computeLogger = Logger.NULL;
    protected Logger logger = Logger.NULL;
    protected NodeMetadata node;
    protected final InitBuilder init;
    protected final boolean runAsRoot;
    protected final Function<NodeMetadata, SshClient> sshFactory;
    protected SshClient ssh;

    public SudoAwareInitManager(Function<NodeMetadata, SshClient> sshFactory, boolean runAsRoot, NodeMetadata node, InitBuilder init) {
        this.sshFactory = Preconditions.checkNotNull(sshFactory, "sshFactory");
        this.runAsRoot = runAsRoot;
        this.node = Preconditions.checkNotNull(node, "node");
        this.init = Preconditions.checkNotNull(init, "init");
    }

    public SudoAwareInitManager init() {
        this.ssh = this.sshFactory.apply(this.node);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecResponse refreshAndRunAction(String action) {
        Preconditions.checkState(this.ssh != null, "please call init() before invoking call");
        try {
            this.ssh.connect();
            ExecResponse execResponse = this.runAction(action);
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    public ExecResponse runAction(String action) {
        String command = this.runAsRoot && Predicates.in(ImmutableSet.of("start", "stop", "run")).apply(action) ? this.execScriptAsRoot(action) : this.execScriptAsDefaultUser(action);
        ExecResponse returnVal = this.runCommand(command);
        if ("status".equals(action)) {
            this.logger.trace("<< %s(%d)", action, returnVal.getExitCode());
        } else if (this.computeLogger.isTraceEnabled()) {
            this.computeLogger.trace("<< %s[%s]", action, returnVal);
        } else {
            this.computeLogger.debug("<< %s(%d)", action, returnVal.getExitCode());
        }
        return returnVal;
    }

    ExecResponse runCommand(String command) {
        String statement = String.format(">> running [%s] as %s@%s", command.replace(this.node.getCredentials().getPassword() != null ? this.node.getCredentials().getPassword() : "XXXXX", "XXXXX"), this.ssh.getUsername(), this.ssh.getHostAddress());
        if (command.endsWith("status")) {
            this.logger.trace(statement, new Object[0]);
        } else {
            this.computeLogger.debug(statement, new Object[0]);
        }
        return this.ssh.exec(command);
    }

    @VisibleForTesting
    String execScriptAsRoot(String action) {
        String command = this.node.getCredentials().identity.equals("root") ? "./" + this.init.getInstanceName() + " " + action : (this.node.getCredentials().shouldAuthenticateSudo() ? String.format("echo '%s'|sudo -S ./%s %s", this.node.getCredentials().getPassword(), this.init.getInstanceName(), action) : "sudo ./" + this.init.getInstanceName() + " " + action);
        return command;
    }

    protected String execScriptAsDefaultUser(String action) {
        return "./" + this.init.getInstanceName() + " " + action;
    }

    public NodeMetadata getNode() {
        return this.node;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("node", this.node).add("name", this.init.getInstanceName()).add("runAsRoot", this.runAsRoot).toString();
    }

    public InitBuilder getStatement() {
        return this.init;
    }
}

