/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.callables.BlockUntilInitScriptStatusIsZeroThenReturnOutput;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete;
import org.jclouds.compute.callables.RunScriptOnNodeUsingSsh;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.config.GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull;
import org.jclouds.compute.config.PersistNodeCredentialsModule;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.functions.CreateSshClientOncePortIsListeningOnNode;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.functions.TemplateOptionsToStatement;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.location.config.LocationModule;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public abstract class BaseComputeServiceContextModule
extends AbstractModule {
    protected AtomicReference<AuthorizationException> authException = new AtomicReference();

    @Override
    protected void configure() {
        this.configureLocationModule();
        this.install(new ComputeServiceTimeoutsModule());
        this.bind(new TypeLiteral<Function<NodeMetadata, SshClient>>(){}).to(CreateSshClientOncePortIsListeningOnNode.class);
        this.bind(new TypeLiteral<Function<TemplateOptions, Statement>>(){}).to(TemplateOptionsToStatement.class);
        this.bind(LoginCredentials.class).annotatedWith(Names.named("image")).toProvider(GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull.class);
        this.bind(new TypeLiteral<Function<Template, LoginCredentials>>(){}).to(DefaultCredentialsFromImageOrOverridingCredentials.class);
        this.install(new FactoryModuleBuilder().implement(RunScriptOnNodeUsingSsh.class, (Annotation)Names.named("direct"), RunScriptOnNodeUsingSsh.class).implement(RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class, (Annotation)Names.named("blocking"), RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class).implement(RunScriptOnNodeAsInitScriptUsingSsh.class, (Annotation)Names.named("nonblocking"), RunScriptOnNodeAsInitScriptUsingSsh.class).build(RunScriptOnNodeFactoryImpl.Factory.class));
        this.install(new PersistNodeCredentialsModule());
        this.bind(RunScriptOnNode.Factory.class).to(RunScriptOnNodeFactoryImpl.class);
        this.install(new FactoryModuleBuilder().implement(new TypeLiteral<Callable<Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).implement(new TypeLiteral<Function<NodeMetadata, Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).build(CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory.class));
        this.install(new FactoryModuleBuilder().implement(new TypeLiteral<Callable<RunScriptOnNode>>(){}, InitializeRunScriptOnNodeOrPlaceInBadMap.class).build(InitializeRunScriptOnNodeOrPlaceInBadMap.Factory.class));
        this.install(new FactoryModuleBuilder().build(BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory.class));
    }

    protected void configureLocationModule() {
        this.install(new LocationModule(this.authException));
    }

    @Provides
    @Singleton
    public Map<OsFamily, Map<String, String>> provideOsVersionMap(ComputeServiceConstants.ReferenceData data, Json json) {
        return (Map)json.fromJson(data.osVersionMapJson, new TypeLiteral<Map<OsFamily, Map<String, String>>>(){}.getType());
    }

    @Provides
    @Named(value="DEFAULT")
    protected TemplateBuilder provideTemplateOptionallyFromProperties(Injector injector, TemplateBuilder template, @Provider String provider, ValueOfConfigurationKeyOrNull config) {
        template = this.provideTemplate(injector, template);
        String imageId = config.apply(provider + ".image-id");
        if (imageId == null) {
            imageId = config.apply("jclouds.image-id");
        }
        if (imageId != null) {
            template.imageId(imageId);
        }
        return template;
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).osVersionMatches("1[012].[01][04]").os64Bit(true);
    }

    @Provides
    @Named(value="DEFAULT")
    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return options;
    }

    @Provides
    @Named(value="NAMING_CONVENTION")
    @Singleton
    protected String provideNamingConvention() {
        return "%s-%s";
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Image>> provideImageMap(@Memoized Supplier<Set<? extends Image>> images) {
        return Suppliers.compose(new Function<Set<? extends Image>, Map<String, ? extends Image>>(){

            @Override
            public Map<String, ? extends Image> apply(Set<? extends Image> from) {
                return Maps.uniqueIndex(from, new Function<Image, String>(){

                    @Override
                    public String apply(Image from) {
                        return from.getId();
                    }
                });
            }
        }, images);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Image>> supplyImageCache(@Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        if (this.shouldParseImagesOnDemand(injector)) {
            return this.supplyImageCache(seconds, imageSupplier);
        }
        return this.supplyNonParsingImageCache(seconds, imageSupplier, injector);
    }

    protected boolean shouldParseImagesOnDemand(Injector injector) {
        return true;
    }

    protected Supplier<Set<? extends Image>> supplyImageCache(@Named(value="jclouds.session-interval") long seconds, final Supplier<Set<? extends Image>> imageSupplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Set<? extends Image>>(this.authException, seconds, new Supplier<Set<? extends Image>>(){

            @Override
            public Set<? extends Image> get() {
                return (Set)imageSupplier.get();
            }
        });
    }

    protected Supplier<Set<? extends Image>> supplyNonParsingImageCache(@Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        return this.supplyImageCache(seconds, imageSupplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Hardware>> provideSizeMap(@Memoized Supplier<Set<? extends Hardware>> sizes) {
        return Suppliers.compose(new Function<Set<? extends Hardware>, Map<String, ? extends Hardware>>(){

            @Override
            public Map<String, ? extends Hardware> apply(Set<? extends Hardware> from) {
                return Maps.uniqueIndex(from, new Function<Hardware, String>(){

                    @Override
                    public String apply(Hardware from) {
                        return from.getId();
                    }
                });
            }
        }, sizes);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Hardware>> supplySizeCache(@Named(value="jclouds.session-interval") long seconds, final Supplier<Set<? extends Hardware>> hardwareSupplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Set<? extends Hardware>>(this.authException, seconds, new Supplier<Set<? extends Hardware>>(){

            @Override
            public Set<? extends Hardware> get() {
                return (Set)hardwareSupplier.get();
            }
        });
    }

    @Provides
    @Singleton
    protected Function<ComputeMetadata, String> indexer() {
        return new Function<ComputeMetadata, String>(){

            @Override
            public String apply(ComputeMetadata from) {
                return from.getProviderId();
            }
        };
    }

    @Singleton
    static class RunScriptOnNodeFactoryImpl
    implements RunScriptOnNode.Factory {
        private final Factory factory;

        @Inject
        RunScriptOnNodeFactoryImpl(Factory factory) {
            this.factory = Preconditions.checkNotNull(factory, "factory");
        }

        @Override
        public RunScriptOnNode create(NodeMetadata node, Statement runScript, RunScriptOptions options) {
            Preconditions.checkNotNull(node, "node");
            Preconditions.checkNotNull(runScript, "runScript");
            Preconditions.checkNotNull(options, "options");
            return !options.shouldWrapInInitScript() ? this.factory.exec(node, runScript, options) : (options.shouldBlockOnComplete() ? this.factory.backgroundAndBlockOnComplete(node, runScript, options) : this.factory.background(node, runScript, options));
        }

        public BlockUntilInitScriptStatusIsZeroThenReturnOutput submit(NodeMetadata node, Statement script, RunScriptOptions options) {
            Preconditions.checkNotNull(node, "node");
            Preconditions.checkNotNull(script, "script");
            Preconditions.checkNotNull(options, "options");
            options.shouldWrapInInitScript();
            return this.factory.backgroundAndBlockOnComplete(node, script, options).init().future();
        }

        static interface Factory {
            @Named(value="direct")
            public RunScriptOnNodeUsingSsh exec(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="blocking")
            public RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete backgroundAndBlockOnComplete(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="nonblocking")
            public RunScriptOnNodeAsInitScriptUsingSsh background(NodeMetadata var1, Statement var2, RunScriptOptions var3);
        }
    }
}

