/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.collect.TransformingSetSupplier;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.strategy.impl.AdaptingComputeServiceStrategies;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

public class ComputeServiceAdapterContextModule<S, A, N, H, I, L>
extends BaseComputeServiceContextModule {
    private Class<A> asyncClientType;
    private Class<S> syncClientType;

    public ComputeServiceAdapterContextModule(Class<S> syncClientType, Class<A> asyncClientType) {
        this.syncClientType = syncClientType;
        this.asyncClientType = asyncClientType;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceContext>(){}).to(TypeLiteral.get(Types.newParameterizedType(ComputeServiceContextImpl.class, new Type[]{this.syncClientType, this.asyncClientType}))).in(Scopes.SINGLETON);
    }

    @Override
    protected void configureLocationModule() {
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Location>> supplyLocationCache(@Named(value="jclouds.session-interval") long seconds, final ComputeServiceAdapter<N, H, I, L> adapter, final Function<L, Location> transformer) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Set<? extends Location>>(this.authException, seconds, new Supplier<Set<? extends Location>>(){

            @Override
            public Set<? extends Location> get() {
                return ImmutableSet.copyOf(Iterables.transform(Iterables.filter(adapter.listLocations(), Predicates.notNull()), transformer));
            }
        });
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Hardware>> provideHardware(final ComputeServiceAdapter<N, H, I, L> adapter, Function<H, Hardware> transformer) {
        return new TransformingSetSupplier<H, Hardware>(new Supplier<Iterable<H>>(){

            @Override
            public Iterable<H> get() {
                return Iterables.filter(adapter.listHardwareProfiles(), Predicates.notNull());
            }
        }, transformer);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Image>> provideImages(final ComputeServiceAdapter<N, H, I, L> adapter, Function<I, Image> transformer, AddDefaultCredentialsToImage addDefaultCredentialsToImage) {
        return new TransformingSetSupplier<I, Image>(new Supplier<Iterable<I>>(){

            @Override
            public Iterable<I> get() {
                return Iterables.filter(adapter.listImages(), Predicates.notNull());
            }
        }, Functions.compose(addDefaultCredentialsToImage, transformer));
    }

    @Provides
    @Singleton
    protected CreateNodeWithGroupEncodedIntoName defineAddNodeWithTagStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected DestroyNodeStrategy defineDestroyNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected GetNodeMetadataStrategy defineGetNodeMetadataStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ListNodesStrategy defineListNodesStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected RebootNodeStrategy defineRebootNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ResumeNodeStrategy defineStartNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected SuspendNodeStrategy defineStopNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Singleton
    public static class AddDefaultCredentialsToImage
    implements Function<Image, Image> {
        private final PopulateDefaultLoginCredentialsForImageStrategy credsForImage;

        @Inject
        public AddDefaultCredentialsToImage(PopulateDefaultLoginCredentialsForImageStrategy credsForImage) {
            this.credsForImage = credsForImage;
        }

        @Override
        public Image apply(Image arg0) {
            if (arg0 == null) {
                return null;
            }
            LoginCredentials credentials = this.credsForImage.apply(arg0);
            return credentials != null ? ImageBuilder.fromImage(arg0).defaultCredentials(credentials).build() : arg0;
        }

        public String toString() {
            return "addDefaultCredentialsToImage()";
        }
    }
}

