/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class OperatingSystem {
    @Nullable
    protected OsFamily family;
    @Nullable
    protected String name;
    @Nullable
    protected String arch;
    @Nullable
    protected String version;
    protected String description;
    protected boolean is64Bit;

    public static Builder builder() {
        return new Builder();
    }

    protected OperatingSystem() {
    }

    public OperatingSystem(@Nullable OsFamily family, @Nullable String name, @Nullable String version, @Nullable String arch, String description, boolean is64Bit) {
        this.family = family;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.description = Preconditions.checkNotNull(description, "description");
        this.is64Bit = is64Bit;
    }

    @Nullable
    public OsFamily getFamily() {
        return this.family;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getArch() {
        return this.arch;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
        result = 31 * result + (this.is64Bit ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.family == null ? other.family != null : !this.family.equals((Object)other.family)) {
            return false;
        }
        if (this.is64Bit != other.is64Bit) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public Builder toBuilder() {
        return OperatingSystem.builder().fromOperatingSystem(this);
    }

    public String toString() {
        return "[name=" + this.name + ", family=" + (Object)((Object)this.family) + ", version=" + this.version + ", arch=" + this.arch + ", is64Bit=" + this.is64Bit + ", description=" + this.description + "]";
    }

    public static class Builder {
        protected OsFamily family;
        protected String name;
        protected String arch;
        protected String version;
        protected String description;
        protected boolean is64Bit;

        public Builder family(@Nullable OsFamily family) {
            this.family = family;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder arch(@Nullable String arch) {
            this.arch = arch;
            return this;
        }

        public Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public Builder description(String description) {
            this.description = Preconditions.checkNotNull(description, "description");
            return this;
        }

        public Builder is64Bit(boolean is64Bit) {
            this.is64Bit = is64Bit;
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.family, this.name, this.version, this.arch, this.description, this.is64Bit);
        }

        public Builder fromOperatingSystem(OperatingSystem in) {
            return this.family(in.getFamily()).name(in.getName()).version(in.getVersion()).arch(in.getArch()).description(in.getDescription()).is64Bit(in.is64Bit());
        }
    }
}

