/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum OsFamily {
    UNRECOGNIZED,
    AIX,
    ARCH,
    CENTOS,
    DARWIN,
    DEBIAN,
    ESX,
    FEDORA,
    FREEBSD,
    GENTOO,
    HPUX,
    LINUX,
    AMZN_LINUX,
    MANDRIVA,
    NETBSD,
    OEL,
    OPENBSD,
    RHEL,
    SIGAR,
    SOLARIS,
    SUSE,
    TURBOLINUX,
    UBUNTU,
    WINDOWS;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static OsFamily fromValue(String osFamily) {
        try {
            return OsFamily.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(osFamily, "osFamily")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

