/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class NodeMetadataImpl
extends ComputeMetadataImpl
implements NodeMetadata {
    private static final long serialVersionUID = 7924307572338157887L;
    private final NodeState state;
    private final int loginPort;
    private final Set<String> publicAddresses;
    private final Set<String> privateAddresses;
    @Nullable
    private final LoginCredentials credentials;
    @Nullable
    private final String group;
    @Nullable
    private final String imageId;
    @Nullable
    private final Hardware hardware;
    @Nullable
    private final OperatingSystem os;
    @Nullable
    private final String hostname;

    @Deprecated
    public NodeMetadataImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, @Nullable String group, @Nullable Hardware hardware, @Nullable String imageId, @Nullable OperatingSystem os, NodeState state, int loginPort, Iterable<String> publicAddresses, Iterable<String> privateAddresses, @Nullable String adminPassword, @Nullable Credentials credentials, String hostname) {
        super(ComputeType.NODE, providerId, name, id, location, uri, userMetadata, tags);
        this.group = group;
        this.hardware = hardware;
        this.imageId = imageId;
        this.os = os;
        this.state = Preconditions.checkNotNull(state, "state");
        this.loginPort = loginPort;
        this.publicAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
        this.privateAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
        this.hostname = hostname;
        LoginCredentials.Builder builder = LoginCredentials.builder(credentials);
        if (adminPassword != null) {
            builder.authenticateSudo(true);
            builder.password(adminPassword);
        }
        this.credentials = builder.build();
    }

    public NodeMetadataImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, @Nullable String group, @Nullable Hardware hardware, @Nullable String imageId, @Nullable OperatingSystem os, NodeState state, int loginPort, Iterable<String> publicAddresses, Iterable<String> privateAddresses, @Nullable LoginCredentials credentials, String hostname) {
        super(ComputeType.NODE, providerId, name, id, location, uri, userMetadata, tags);
        this.group = group;
        this.hardware = hardware;
        this.imageId = imageId;
        this.os = os;
        this.state = Preconditions.checkNotNull(state, "state");
        this.loginPort = loginPort;
        this.publicAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(publicAddresses, "publicAddresses"));
        this.privateAddresses = ImmutableSet.copyOf(Preconditions.checkNotNull(privateAddresses, "privateAddresses"));
        this.credentials = credentials;
        this.hostname = hostname;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Hardware getHardware() {
        return this.hardware;
    }

    @Override
    @Deprecated
    public String getAdminPassword() {
        return this.credentials != null && this.credentials.shouldAuthenticateSudo() ? this.credentials.getPassword() : null;
    }

    @Override
    public LoginCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public Set<String> getPublicAddresses() {
        return this.publicAddresses;
    }

    @Override
    public Set<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    @Override
    public NodeState getState() {
        return this.state;
    }

    @Override
    public int getLoginPort() {
        return this.loginPort;
    }

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.os;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String toString() {
        return "[id=" + this.getId() + ", providerId=" + this.getProviderId() + ", group=" + this.getGroup() + ", name=" + this.getName() + ", location=" + this.getLocation() + ", uri=" + this.getUri() + ", imageId=" + this.getImageId() + ", os=" + this.getOperatingSystem() + ", state=" + (Object)((Object)this.getState()) + ", loginPort=" + this.getLoginPort() + ", hostname=" + this.getHostname() + ", privateAddresses=" + this.privateAddresses + ", publicAddresses=" + this.publicAddresses + ", hardware=" + this.getHardware() + ", loginUser=" + (this.credentials != null ? this.credentials.identity : null) + ", userMetadata=" + this.getUserMetadata() + ", tags=" + this.tags + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.loginPort;
        result = 31 * result + (this.privateAddresses == null ? 0 : ((Object)this.privateAddresses).hashCode());
        result = 31 * result + (this.publicAddresses == null ? 0 : ((Object)this.publicAddresses).hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.hardware == null ? 0 : this.hardware.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeMetadataImpl other = (NodeMetadataImpl)obj;
        if (this.loginPort != other.loginPort) {
            return false;
        }
        if (this.privateAddresses == null ? other.privateAddresses != null : !((Object)this.privateAddresses).equals(other.privateAddresses)) {
            return false;
        }
        if (this.publicAddresses == null ? other.publicAddresses != null : !((Object)this.publicAddresses).equals(other.publicAddresses)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.hardware == null ? other.hardware != null : !this.hardware.equals(other.hardware)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        return !(this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials));
    }
}

