/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class TemplateImpl
implements Template {
    private final Image image;
    private final Hardware size;
    private final Location location;
    private final TemplateOptions options;

    public TemplateImpl(Image image, Hardware size, Location location, TemplateOptions options) {
        this.image = Preconditions.checkNotNull(image, "image");
        this.size = Preconditions.checkNotNull(size, "size");
        this.location = Preconditions.checkNotNull(location, "location");
        this.options = Preconditions.checkNotNull(options, "options");
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public Hardware getHardware() {
        return this.size;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public TemplateOptions getOptions() {
        return this.options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateImpl other = (TemplateImpl)obj;
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    public String toString() {
        return "[location=" + this.location + ", image=" + this.image + ", size=" + this.size + ", options=" + this.options + "]";
    }

    protected Object clone() throws CloneNotSupportedException {
        return new TemplateImpl(this.image, this.size, this.location, this.options);
    }
}

