/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.RetryIfSocketNotYetOpen;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.net.IPSocket;
import org.jclouds.ssh.SshClient;

@Singleton
public class CreateSshClientOncePortIsListeningOnNode
implements Function<NodeMetadata, SshClient> {
    @Inject(optional=true)
    SshClient.Factory sshFactory;
    private final RetryIfSocketNotYetOpen socketTester;

    @Inject
    public CreateSshClientOncePortIsListeningOnNode(RetryIfSocketNotYetOpen socketTester) {
        this.socketTester = socketTester;
    }

    @Override
    public SshClient apply(NodeMetadata node) {
        Preconditions.checkState(this.sshFactory != null, "ssh requested, but no SshModule configured");
        Preconditions.checkNotNull(node.getCredentials(), "no credentials found for node %s", node.getId());
        Preconditions.checkNotNull(node.getCredentials().identity, "no login identity found for node %s", node.getId());
        Preconditions.checkNotNull(node.getCredentials().credential, "no credential found for %s on node %s", node.getCredentials().identity, node.getId());
        IPSocket socket = ComputeServiceUtils.findReachableSocketOnNode(this.socketTester, node, node.getLoginPort());
        return this.sshFactory.create(socket, node.getCredentials());
    }
}

