/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Maps2;

@Singleton
public class BaseComputeService
implements ComputeService {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ComputeServiceContext context;
    protected final Map<String, Credentials> credentialStore;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwareProfiles;
    private final Supplier<Set<? extends Location>> locations;
    private final ListNodesStrategy listNodesStrategy;
    private final GetNodeMetadataStrategy getNodeMetadataStrategy;
    private final CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy;
    private final RebootNodeStrategy rebootNodeStrategy;
    private final DestroyNodeStrategy destroyNodeStrategy;
    private final ResumeNodeStrategy resumeNodeStrategy;
    private final SuspendNodeStrategy suspendNodeStrategy;
    private final Provider<TemplateBuilder> templateBuilderProvider;
    private final Provider<TemplateOptions> templateOptionsProvider;
    private final Predicate<NodeMetadata> nodeRunning;
    private final Predicate<NodeMetadata> nodeTerminated;
    private final Predicate<NodeMetadata> nodeSuspended;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final ComputeServiceConstants.Timeouts timeouts;
    private final InitAdminAccess initAdminAccess;
    private final PersistNodeCredentials persistNodeCredentials;
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final ExecutorService executor;

    @Inject
    protected BaseComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, Provider<TemplateOptions> templateOptionsProvider, @Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, @Named(value="NODE_TERMINATED") Predicate<NodeMetadata> nodeTerminated, @Named(value="NODE_SUSPENDED") Predicate<NodeMetadata> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, InitAdminAccess initAdminAccess, RunScriptOnNode.Factory runScriptOnNodeFactory, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore");
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwareProfiles = Preconditions.checkNotNull(hardwareProfiles, "hardwareProfiles");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.listNodesStrategy = Preconditions.checkNotNull(listNodesStrategy, "listNodesStrategy");
        this.getNodeMetadataStrategy = Preconditions.checkNotNull(getNodeMetadataStrategy, "getNodeMetadataStrategy");
        this.runNodesAndAddToSetStrategy = Preconditions.checkNotNull(runNodesAndAddToSetStrategy, "runNodesAndAddToSetStrategy");
        this.rebootNodeStrategy = Preconditions.checkNotNull(rebootNodeStrategy, "rebootNodeStrategy");
        this.resumeNodeStrategy = Preconditions.checkNotNull(resumeNodeStrategy, "resumeNodeStrategy");
        this.suspendNodeStrategy = Preconditions.checkNotNull(suspendNodeStrategy, "suspendNodeStrategy");
        this.destroyNodeStrategy = Preconditions.checkNotNull(destroyNodeStrategy, "destroyNodeStrategy");
        this.templateBuilderProvider = Preconditions.checkNotNull(templateBuilderProvider, "templateBuilderProvider");
        this.templateOptionsProvider = Preconditions.checkNotNull(templateOptionsProvider, "templateOptionsProvider");
        this.nodeRunning = Preconditions.checkNotNull(nodeRunning, "nodeRunning");
        this.nodeTerminated = Preconditions.checkNotNull(nodeTerminated, "nodeTerminated");
        this.nodeSuspended = Preconditions.checkNotNull(nodeSuspended, "nodeSuspended");
        this.initScriptRunnerFactory = Preconditions.checkNotNull(initScriptRunnerFactory, "initScriptRunnerFactory");
        this.timeouts = Preconditions.checkNotNull(timeouts, "timeouts");
        this.initAdminAccess = Preconditions.checkNotNull(initAdminAccess, "initAdminAccess");
        this.runScriptOnNodeFactory = Preconditions.checkNotNull(runScriptOnNodeFactory, "runScriptOnNodeFactory");
        this.persistNodeCredentials = Preconditions.checkNotNull(persistNodeCredentials, "persistNodeCredentials");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public ComputeServiceContext getContext() {
        return this.context;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Preconditions.checkNotNull(group, "group cannot be null");
        Preconditions.checkNotNull(template.getLocation(), "location");
        this.logger.debug(">> running %d node%s group(%s) location(%s) image(%s) hardwareProfile(%s) options(%s)", count, count > 1 ? "s" : "", group, template.getLocation().getId(), template.getImage().getId(), template.getHardware().getId(), template.getOptions());
        Set<NodeMetadata> goodNodes = Sets.newLinkedHashSet();
        Map<NodeMetadata, Exception> badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap<NodeMetadata, CustomizationResponse> customizationResponses = LinkedHashMultimap.create();
        if (template.getOptions().getRunScript() != null) {
            this.initAdminAccess.visit(template.getOptions().getRunScript());
        }
        Map<?, Future<Void>> responses = this.runNodesAndAddToSetStrategy.execute(group, count, template, goodNodes, badNodes, customizationResponses);
        Map<?, Exception> executionExceptions = FutureIterables.awaitCompletion(responses, this.executor, null, this.logger, "createNodesInGroup(" + group + ")");
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.always(template.getOptions().getRunScript());
        badNodes = Maps2.transformKeys(badNodes, fn);
        goodNodes = ImmutableSet.copyOf(Iterables.transform(goodNodes, fn));
        if (executionExceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunNodesException(group, count, template, goodNodes, executionExceptions, badNodes);
        }
        return goodNodes;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateBuilder().any().options(templateOptions).build());
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateOptions());
    }

    @Override
    public void destroyNode(final String id) {
        boolean successful;
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> destroying node(%s)", id);
        final AtomicReference node = new AtomicReference();
        RetryablePredicate<String> tester = new RetryablePredicate<String>(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                try {
                    NodeMetadata md = BaseComputeService.this.destroyNodeStrategy.destroyNode(id);
                    if (md != null) {
                        node.set(md);
                    }
                    return true;
                }
                catch (IllegalStateException e) {
                    BaseComputeService.this.logger.warn("<< illegal state destroying node(%s)", id);
                    return false;
                }
            }
        }, this.timeouts.nodeRunning, 1000L, TimeUnit.MILLISECONDS);
        boolean bl = successful = tester.apply(id) && (node.get() == null || this.nodeTerminated.apply((NodeMetadata)node.get()));
        if (successful) {
            this.credentialStore.remove("node#" + id);
        }
        this.logger.debug("<< destroyed node(%s) success(%s)", id, successful);
    }

    @Override
    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> destroying nodes matching(%s)", filter);
        LinkedHashSet<NodeMetadata> set = Sets.newLinkedHashSet(FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), new Function<NodeMetadata, Future<NodeMetadata>>(){

            @Override
            public Future<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.executor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.destroyNode(from.getId());
                        return from;
                    }

                    public String toString() {
                        return "destroyNode(" + from.getId() + ")";
                    }
                });
            }
        }, this.executor, null, this.logger, "destroyNodesMatching(" + filter + ")"));
        this.logger.debug("<< destroyed(%d)", set.size());
        return set;
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminated(Predicate<NodeMetadata> filter) {
        return Sets.filter(this.detailsOnAllNodes(), Predicates.and(Preconditions.checkNotNull(filter, "filter"), Predicates.not(NodePredicates.TERMINATED)));
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(Predicate<NodeMetadata> filter) {
        Iterable<? extends NodeMetadata> nodes = this.nodesMatchingFilterAndNotTerminated(filter);
        if (Iterables.size(nodes) == 0) {
            throw new NoSuchElementException("no nodes matched filter: " + filter);
        }
        return nodes;
    }

    public Set<ComputeMetadata> listNodes() {
        this.logger.debug(">> listing nodes", new Object[0]);
        LinkedHashSet<ComputeMetadata> set = Sets.newLinkedHashSet(this.listNodesStrategy.listNodes());
        this.logger.debug("<< list(%d)", set.size());
        return set;
    }

    @Override
    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> filter) {
        Preconditions.checkNotNull(filter, "filter");
        this.logger.debug(">> listing node details matching(%s)", filter);
        LinkedHashSet<? extends NodeMetadata> set = Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(filter));
        this.logger.debug("<< list(%d)", set.size());
        return set;
    }

    @Override
    public Set<? extends Hardware> listHardwareProfiles() {
        return this.hardwareProfiles.get();
    }

    @Override
    public Set<? extends Image> listImages() {
        return this.images.get();
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.locations.get();
    }

    @Override
    public TemplateBuilder templateBuilder() {
        return this.templateBuilderProvider.get();
    }

    @Override
    public NodeMetadata getNodeMetadata(String id) {
        Preconditions.checkNotNull(id, "id");
        return this.getNodeMetadataStrategy.getNode(id);
    }

    @Override
    public void rebootNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> rebooting node(%s)", id);
        NodeMetadata node = this.rebootNodeStrategy.rebootNode(id);
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< rebooted node(%s) success(%s)", id, successful);
    }

    @Override
    public void rebootNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> rebooting nodes matching(%s)", filter);
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), new Function<NodeMetadata, Future<Void>>(){

            @Override
            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.rebootNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, this.executor, null, this.logger, "rebootNodesMatching(" + filter + ")");
        this.logger.debug("<< rebooted", new Object[0]);
    }

    @Override
    public void resumeNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> resuming node(%s)", id);
        NodeMetadata node = this.resumeNodeStrategy.resumeNode(id);
        boolean successful = this.nodeRunning.apply(node);
        this.logger.debug("<< resumed node(%s) success(%s)", id, successful);
    }

    @Override
    public void resumeNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> resuming nodes matching(%s)", filter);
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), new Function<NodeMetadata, Future<Void>>(){

            @Override
            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.resumeNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, this.executor, null, this.logger, "resumeNodesMatching(" + filter + ")");
        this.logger.debug("<< resumed", new Object[0]);
    }

    @Override
    public void suspendNode(String id) {
        Preconditions.checkNotNull(id, "id");
        this.logger.debug(">> suspending node(%s)", id);
        NodeMetadata node = this.suspendNodeStrategy.suspendNode(id);
        boolean successful = this.nodeSuspended.apply(node);
        this.logger.debug("<< suspended node(%s) success(%s)", id, successful);
    }

    @Override
    public void suspendNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> suspending nodes matching(%s)", filter);
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), new Function<NodeMetadata, Future<Void>>(){

            @Override
            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.suspendNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, this.executor, null, this.logger, "suspendNodesMatching(" + filter + ")");
        this.logger.debug("<< suspended", new Object[0]);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec(Preconditions.checkNotNull(runScript, "runScript")));
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, runScript, RunScriptOptions.NONE);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec(Preconditions.checkNotNull(runScript, "runScript")), options);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        Preconditions.checkNotNull(filter, "filter");
        Preconditions.checkNotNull(runScript, "runScript");
        Preconditions.checkNotNull(options, "options");
        LinkedHashMap<NodeMetadata, ExecResponse> goodNodes = Maps.newLinkedHashMap();
        Map<NodeMetadata, Exception> badNodes = Maps.newLinkedHashMap();
        LinkedHashMap<NodeMetadata, Future<ExecResponse>> responses = Maps.newLinkedHashMap();
        Map exceptions = ImmutableMap.of();
        this.initAdminAccess.visit(runScript);
        Iterable<? extends RunScriptOnNode> scriptRunners = this.transformNodesIntoInitializedScriptRunners(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), runScript, options, badNodes);
        if (Iterables.size(scriptRunners) > 0) {
            for (RunScriptOnNode runScriptOnNode : scriptRunners) {
                responses.put(runScriptOnNode.getNode(), this.executor.submit(new RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(runScriptOnNode, goodNodes, badNodes)));
            }
            exceptions = FutureIterables.awaitCompletion(responses, this.executor, null, this.logger, "runScriptOnNodesMatching(" + filter + ")");
        }
        Function<NodeMetadata, NodeMetadata> fn = this.persistNodeCredentials.ifAdminAccess(runScript);
        badNodes = Maps2.transformKeys(badNodes, fn);
        goodNodes = Maps2.transformKeys(goodNodes, fn);
        if (exceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunScriptOnNodesException(runScript, options, goodNodes, exceptions, badNodes);
        }
        return goodNodes;
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.runScriptOnNode(id, Statements.exec(Preconditions.checkNotNull(runScript, "runScript")), options);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript) {
        return this.runScriptOnNode(id, runScript, RunScriptOptions.NONE);
    }

    @Override
    public ExecResponse runScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getState() != NodeState.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + (Object)((Object)node.getState()));
        }
        this.initAdminAccess.visit(runScript);
        node = this.updateNodeWithCredentialsIfPresent(node, options);
        ExecResponse response = this.runScriptOnNodeFactory.create(node, runScript, options).init().call();
        this.persistNodeCredentials.ifAdminAccess(runScript).apply(node);
        return response;
    }

    @Override
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, final Statement runScript, RunScriptOptions options) {
        NodeMetadata node = this.getNodeMetadata(id);
        if (node == null) {
            throw new NoSuchElementException(id);
        }
        if (node.getState() != NodeState.RUNNING) {
            throw new IllegalStateException("node " + id + " needs to be running before executing a script on it. current state: " + (Object)((Object)node.getState()));
        }
        this.initAdminAccess.visit(runScript);
        final NodeMetadata node1 = this.updateNodeWithCredentialsIfPresent(node, options);
        ListenableFuture<ExecResponse> response = this.runScriptOnNodeFactory.submit(node1, runScript, options);
        response.addListener(new Runnable(){

            @Override
            public void run() {
                BaseComputeService.this.persistNodeCredentials.ifAdminAccess(runScript).apply(node1);
            }
        }, this.executor);
        return response;
    }

    private Iterable<? extends RunScriptOnNode> transformNodesIntoInitializedScriptRunners(Iterable<? extends NodeMetadata> nodes, Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
        return Iterables.filter(FutureIterables.transformParallel(nodes, new TransformNodesIntoInitializedScriptRunners(script, options, badNodes), this.executor, null, this.logger, "initialize script runners"), Predicates.notNull());
    }

    private Set<? extends NodeMetadata> detailsOnAllNodes() {
        return Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(NodePredicates.all()));
    }

    @Override
    public TemplateOptions templateOptions() {
        return this.templateOptionsProvider.get();
    }

    protected NodeMetadata updateNodeWithCredentialsIfPresent(NodeMetadata node, RunScriptOptions options) {
        Preconditions.checkNotNull(node, "node");
        LoginCredentials.Builder builder = LoginCredentials.builder(node.getCredentials());
        if (options.getLoginUser() != null) {
            builder.user(options.getLoginUser());
        }
        if (options.hasLoginPasswordOption()) {
            if (options.hasLoginPassword()) {
                builder.password(options.getLoginPassword());
            } else {
                builder.noPassword();
            }
        }
        if (options.hasLoginPrivateKeyOption()) {
            if (options.hasLoginPrivateKey()) {
                builder.privateKey(options.getLoginPrivateKey());
            } else {
                builder.noPrivateKey();
            }
        }
        if (options.shouldAuthenticateSudo() != null) {
            builder.authenticateSudo(true);
        }
        return NodeMetadataBuilder.fromNodeMetadata(node).credentials(builder.build()).build();
    }

    private final class TransformNodesIntoInitializedScriptRunners
    implements Function<NodeMetadata, Future<RunScriptOnNode>> {
        private final Map<NodeMetadata, Exception> badNodes;
        private final Statement script;
        private final RunScriptOptions options;

        private TransformNodesIntoInitializedScriptRunners(Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
            this.badNodes = Preconditions.checkNotNull(badNodes, "badNodes");
            this.script = Preconditions.checkNotNull(script, "script");
            this.options = Preconditions.checkNotNull(options, "options");
        }

        @Override
        public Future<RunScriptOnNode> apply(NodeMetadata node) {
            node = BaseComputeService.this.updateNodeWithCredentialsIfPresent(node, this.options);
            return BaseComputeService.this.executor.submit(BaseComputeService.this.initScriptRunnerFactory.create(node, this.script, this.options, this.badNodes));
        }
    }
}

