/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.Utils;
import org.jclouds.domain.Credentials;
import org.jclouds.rest.RestContext;

@Singleton
public class ComputeServiceContextImpl<S, A>
implements ComputeServiceContext {
    private final ComputeService computeService;
    private final RestContext<S, A> providerSpecificContext;
    private final Utils utils;
    private final Map<String, Credentials> credentialStore;

    @Inject
    public ComputeServiceContextImpl(ComputeService computeService, Map<String, Credentials> credentialStore, Utils utils, RestContext providerSpecificContext) {
        this.credentialStore = credentialStore;
        this.utils = utils;
        this.providerSpecificContext = providerSpecificContext;
        this.computeService = Preconditions.checkNotNull(computeService, "computeService");
    }

    @Override
    public ComputeService getComputeService() {
        return this.computeService;
    }

    @Override
    public <S, A> RestContext<S, A> getProviderSpecificContext() {
        return this.providerSpecificContext;
    }

    @Override
    public void close() {
        this.providerSpecificContext.close();
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    public int hashCode() {
        return this.providerSpecificContext.hashCode();
    }

    public String toString() {
        return this.providerSpecificContext.toString();
    }

    public boolean equals(Object obj) {
        return this.providerSpecificContext.equals(obj);
    }

    @Override
    public Map<String, Credentials> getCredentialStore() {
        return this.credentialStore;
    }

    @Override
    public Map<String, Credentials> credentialStore() {
        return this.credentialStore;
    }
}

