/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.logging.Logger;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.predicates.SocketOpen;

public class RetryIfSocketNotYetOpen
implements Predicate<IPSocket> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final SocketOpen socketTester;
    private long timeoutValue;
    private TimeUnit timeoutUnits;

    public RetryIfSocketNotYetOpen(SocketOpen socketTester, Logger logger, long timeoutValue, TimeUnit timeoutUnits) {
        this.socketTester = socketTester;
        this.logger = logger;
        this.timeoutValue = timeoutValue;
        this.timeoutUnits = timeoutUnits;
    }

    public RetryIfSocketNotYetOpen(SocketOpen socketTester, Logger logger) {
        this(socketTester, logger, 0L, TimeUnit.MILLISECONDS);
    }

    @Inject
    public RetryIfSocketNotYetOpen(SocketOpen socketTester, ComputeServiceConstants.Timeouts timeouts) {
        this(socketTester, Logger.NULL, timeouts.portOpen, TimeUnit.MILLISECONDS);
    }

    public RetryIfSocketNotYetOpen milliseconds(long milliseconds) {
        this.timeoutValue = milliseconds;
        this.timeoutUnits = TimeUnit.MILLISECONDS;
        return this;
    }

    public RetryIfSocketNotYetOpen seconds(long seconds) {
        this.timeoutValue = seconds;
        this.timeoutUnits = TimeUnit.SECONDS;
        return this;
    }

    public String toString() {
        return "retryIfSocketNotYetOpen(" + this.timeoutValue + " " + (Object)((Object)this.timeoutUnits) + ")";
    }

    @Override
    public boolean apply(IPSocket socket) {
        this.logger.debug(">> blocking on socket %s for %d %s", new Object[]{socket, this.timeoutValue, this.timeoutUnits});
        long period = this.timeoutUnits.convert(1L, TimeUnit.SECONDS);
        RetryablePredicate<IPSocket> tester = new RetryablePredicate<IPSocket>(this.socketTester, this.timeoutValue, period, this.timeoutUnits);
        boolean passed = tester.apply(socket);
        if (passed) {
            this.logger.debug("<< socket %s opened", socket);
        } else {
            this.logger.warn("<< socket %s didn't open after %d %s", new Object[]{socket, this.timeoutValue, this.timeoutUnits});
        }
        return passed;
    }
}

