/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;

public class RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap
implements Callable<ExecResponse> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final RunScriptOnNode runScriptOnNode;
    private final Map<NodeMetadata, Exception> badNodes;
    private final Map<NodeMetadata, ExecResponse> goodNodes;
    private transient boolean tainted;

    @AssistedInject
    public RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(RunScriptOnNode runScriptOnNode, Map<NodeMetadata, ExecResponse> goodNodes, Map<NodeMetadata, Exception> badNodes) {
        this.runScriptOnNode = Preconditions.checkNotNull(runScriptOnNode, "runScriptOnNode");
        this.badNodes = Preconditions.checkNotNull(badNodes, "badNodes");
        this.goodNodes = Preconditions.checkNotNull(goodNodes, "goodNodes");
    }

    @Override
    public ExecResponse call() {
        Preconditions.checkState(this.runScriptOnNode != null, "runScriptOnNode must be set");
        Preconditions.checkState(!this.tainted, "this object is not designed to be reused: %s", this.toString());
        this.tainted = true;
        try {
            ExecResponse exec = this.runScriptOnNode.call();
            this.logger.trace("<< script output for node(%s): %s", this.runScriptOnNode.getNode().getId(), exec);
            this.logger.debug("<< options applied node(%s)", this.runScriptOnNode.getNode().getId());
            this.goodNodes.put(this.runScriptOnNode.getNode(), exec);
            return exec;
        }
        catch (Exception e) {
            this.logger.error(e, "<< problem applying options to node(%s): ", this.runScriptOnNode.getNode().getId(), Throwables.getRootCause(e).getMessage());
            this.badNodes.put(this.runScriptOnNode.getNode(), e);
            return null;
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("runScriptOnNode", this.runScriptOnNode).add("goodNodes", this.goodNodes).add("badNodes", this.badNodes).toString();
    }
}

