/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.concurrent.Futures;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;

@Beta
public class FutureIterables {
    @Resource
    private static Logger logger = Logger.CONSOLE;
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private static int maxRetries = 5;
    @Inject(optional=true)
    @Named(value="jclouds.retries-delay-start")
    private static long delayStart = 50L;
    @Inject(optional=true)
    private static BackoffLimitedRetryHandler retryHandler = BackoffLimitedRetryHandler.INSTANCE;

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, Future<T>> function) {
        return FutureIterables.transformParallel(fromIterable, function, MoreExecutors.sameThreadExecutor(), null);
    }

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, Future<T>> function, ExecutorService exec, @Nullable Long maxTime) {
        return FutureIterables.transformParallel(fromIterable, function, exec, maxTime, logger, "transforming");
    }

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, Future<T>> function, ExecutorService exec, @Nullable Long maxTime, Logger logger, String logPrefix) {
        return FutureIterables.transformParallel(fromIterable, function, exec, maxTime, logger, logPrefix, retryHandler, maxRetries);
    }

    public static <F, T> Iterable<T> transformParallel(Iterable<F> fromIterable, Function<? super F, Future<T>> function, ExecutorService exec, @Nullable Long maxTime, Logger logger, String logPrefix, BackoffLimitedRetryHandler retryHandler, int maxRetries) {
        Map exceptions = Maps.newHashMap();
        HashMap<F, Future<T>> responses = Maps.newHashMap();
        for (int i = 0; i < maxRetries; ++i) {
            for (F from : fromIterable) {
                responses.put(from, function.apply(from));
            }
            exceptions = FutureIterables.awaitCompletion(responses, exec, maxTime, logger, logPrefix);
            if (exceptions.size() <= 0) break;
            fromIterable = exceptions.keySet();
            retryHandler.imposeBackoffExponentialDelay(delayStart, 2, i + 1, maxRetries, String.format("error %s: %s: %s", logPrefix, fromIterable, exceptions));
        }
        if (exceptions.size() > 0) {
            throw new RuntimeException(String.format("error %s: %s: %s", logPrefix, fromIterable, exceptions));
        }
        return FutureIterables.unwrap(responses.values());
    }

    public static <T> Map<T, Exception> awaitCompletion(Map<T, ? extends Future<?>> responses, ExecutorService exec, @Nullable Long maxTime, final Logger logger, final String logPrefix) {
        if (responses.size() == 0) {
            return ImmutableMap.of();
        }
        final int total = responses.size();
        final CountDownLatch doneSignal = new CountDownLatch(total);
        final AtomicInteger complete = new AtomicInteger(0);
        final AtomicInteger errors = new AtomicInteger(0);
        final long start = System.currentTimeMillis();
        final HashMap errorMap = Maps.newHashMap();
        for (final Map.Entry<T, Future<?>> future : responses.entrySet()) {
            Futures.makeListenable(future.getValue(), exec).addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Future)future.getValue()).get();
                        complete.incrementAndGet();
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                        FutureIterables.logException(logger, logPrefix, total, complete.get(), errors.get(), start, e);
                        errorMap.put(future.getKey(), e);
                    }
                    doneSignal.countDown();
                }

                public String toString() {
                    return "callGetOnFuture(" + future.getKey() + "," + future.getValue() + ")";
                }
            }, exec);
        }
        try {
            String message;
            if (maxTime != null) {
                doneSignal.await(maxTime, TimeUnit.MILLISECONDS);
            } else {
                doneSignal.await();
            }
            if (errors.get() > 0) {
                message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
                RuntimeException exception = new RuntimeException(message);
                logger.error(exception, message, new Object[0]);
            }
            if (logger.isTraceEnabled()) {
                message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
                logger.trace(message, new Object[0]);
            }
        }
        catch (InterruptedException e) {
            String message = FutureIterables.message(logPrefix, total, complete.get(), errors.get(), start);
            TimeoutException exception = new TimeoutException(message);
            logger.error(exception, message, new Object[0]);
            Throwables.propagate(exception);
        }
        return errorMap;
    }

    public static <T> Iterable<T> unwrap(Iterable<Future<T>> values) {
        return Iterables.transform(values, new Function<Future<T>, T>(){

            @Override
            public T apply(Future<T> from) {
                try {
                    return from.get();
                }
                catch (InterruptedException e) {
                    Throwables.propagate(e);
                }
                catch (ExecutionException e) {
                    Throwables.propagate(e);
                }
                return null;
            }

            public String toString() {
                return "callGetOnFuture()";
            }
        });
    }

    private static void logException(Logger logger, String logPrefix, int total, int complete, int errors, long start, Exception e) {
        String message = FutureIterables.message(logPrefix, total, complete, errors, start);
        logger.error(e, message, new Object[0]);
    }

    private static String message(String prefix, int size, int complete, int errors, long start) {
        return String.format("%s, completed: %d/%d, errors: %d, rate: %dms/op", prefix, complete, size, errors, (long)((double)(System.currentTimeMillis() - start) / (double)size));
    }

    protected static boolean timeOut(long start, Long maxTime) {
        return maxTime != null ? System.currentTimeMillis() < start + maxTime : false;
    }
}

