/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ValueOfConfigurationKeyOrNull
implements Function<String, String> {
    protected final Injector injector;

    @Inject
    public ValueOfConfigurationKeyOrNull(Injector injector) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    public String apply(String configurationKey) {
        Preconditions.checkNotNull(configurationKey, "configurationKey");
        try {
            return Strings.emptyToNull(this.injector.getInstance(Key.get(String.class, (Annotation)Names.named(configurationKey))));
        }
        catch (ConfigurationException e) {
            return null;
        }
    }
}

