/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import org.jclouds.encryption.internal.Base64;
import org.jclouds.io.InputSuppliers;

@Beta
public class CryptoStreams {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String hex(byte[] in) {
        byte[] hex = new byte[2 * in.length];
        int index = 0;
        for (byte b : in) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String base64(byte[] in) {
        return Base64.encodeBytes(in, 8);
    }

    public static byte[] base64(String in) {
        return Base64.decode(in);
    }

    public static String md5Hex(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CryptoStreams.hex(CryptoStreams.md5(supplier));
    }

    public static String md5Base64(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CryptoStreams.base64(CryptoStreams.md5(supplier));
    }

    public static String macBase64(InputSupplier<? extends InputStream> supplier, Mac mac) throws IOException {
        return CryptoStreams.base64(CryptoStreams.mac(supplier, mac));
    }

    public static byte[] digest(InputSupplier<? extends InputStream> supplier, final MessageDigest md) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                md.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return md.digest();
            }
        });
    }

    public static byte[] sha1(InputSupplier<? extends InputStream> supplier) throws IOException {
        try {
            return CryptoStreams.digest(supplier, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public static byte[] sha1(byte[] in) {
        try {
            return CryptoStreams.sha1(ByteStreams.newInputStreamSupplier(in));
        }
        catch (IOException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public static byte[] md5(InputSupplier<? extends InputStream> supplier) throws IOException {
        try {
            return CryptoStreams.digest(supplier, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public static byte[] md5(byte[] in) {
        try {
            return CryptoStreams.md5(ByteStreams.newInputStreamSupplier(in));
        }
        catch (IOException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public static byte[] mac(InputSupplier<? extends InputStream> supplier, final Mac mac) throws IOException {
        return ByteStreams.readBytes(Preconditions.checkNotNull(supplier, "supplier"), new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                mac.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return mac.doFinal();
            }
        });
    }

    public static String base64Encode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(InputSuppliers.base64Encoder(supplier), new ByteProcessor<String>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                out.write(buf, off, len);
                return true;
            }

            @Override
            public String getResult() {
                return new String(out.toByteArray(), Charsets.UTF_8);
            }
        });
    }

    public static byte[] base64Decode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(InputSuppliers.base64Decoder(supplier), new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                out.write(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return out.toByteArray();
            }
        });
    }

    public static String hexEncode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final StringBuilder out = new StringBuilder();
        return ByteStreams.readBytes(supplier, new ByteProcessor<String>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                char[] hex = new char[2 * len];
                int index = 0;
                for (int i = off; i < off + len; ++i) {
                    byte b = buf[i];
                    int v = b & 0xFF;
                    hex[index++] = (char)HEX_CHAR_TABLE[v >>> 4];
                    hex[index++] = (char)HEX_CHAR_TABLE[v & 0xF];
                }
                out.append(hex);
                return true;
            }

            @Override
            public String getResult() {
                return out.toString();
            }
        });
    }

    public static byte[] hexDecode(InputSupplier<? extends InputStream> supplier) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){
            int currentPos = 0;

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                try {
                    if (this.currentPos == 0 && new String(Arrays.copyOfRange(buf, off, 2), "ASCII").equals("0x")) {
                        off += 2;
                    }
                    byte[] decoded = CryptoStreams.hex(new String(Arrays.copyOfRange(buf, off, len), "ASCII"));
                    out.write(decoded, 0, decoded.length);
                    this.currentPos += len;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("ASCII must be supported");
                }
                return true;
            }

            @Override
            public byte[] getResult() {
                return out.toByteArray();
            }
        });
    }
}

