/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    public static final Pattern MILLIS_PATTERN = Pattern.compile("(.*\\.[0-9][0-9][0-9])[0-9]*Z?");
    public static final Pattern TZ_PATTERN = Pattern.compile("(.*)[+-][0-9][0-9]:?[0-9][0-9]Z?");
    public static final Pattern SECOND_PATTERN = Pattern.compile(".*[0-2][0-9]:00");

    public static String trimToMillis(String toParse) {
        Matcher matcher = MILLIS_PATTERN.matcher(toParse);
        if (matcher.find()) {
            toParse = matcher.group(1) + 'Z';
        }
        return toParse;
    }

    public static String trimTZ(String toParse) {
        Matcher matcher = TZ_PATTERN.matcher(toParse);
        if (matcher.find()) {
            toParse = matcher.group(1) + 'Z';
        }
        if (toParse.length() == 25 && SECOND_PATTERN.matcher(toParse).matches()) {
            toParse = toParse.substring(0, toParse.length() - 6) + 'Z';
        }
        return toParse;
    }
}

