/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.deltacloud.compute.functions.DeltacloudImageToOperatingSystem;
import org.jclouds.deltacloud.domain.Image;

@Singleton
public class DeltacloudImageToImage
implements Function<Image, org.jclouds.compute.domain.Image> {
    private final DeltacloudImageToOperatingSystem imageToOperatingSystem;

    @Inject
    public DeltacloudImageToImage(DeltacloudImageToOperatingSystem imageToOperatingSystem) {
        this.imageToOperatingSystem = imageToOperatingSystem;
    }

    @Override
    public org.jclouds.compute.domain.Image apply(Image from) {
        ImageBuilder builder = new ImageBuilder();
        builder.id(from.getHref().toASCIIString());
        builder.providerId(from.getId());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.description(from.getDescription());
        builder.operatingSystem(this.imageToOperatingSystem.apply(from));
        return builder.build();
    }
}

