/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.config;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.deltacloud.DeltacloudAsyncClient;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.collections.HardwareProfiles;
import org.jclouds.deltacloud.collections.Images;
import org.jclouds.deltacloud.collections.InstanceStates;
import org.jclouds.deltacloud.collections.Instances;
import org.jclouds.deltacloud.collections.Realms;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.handlers.DeltacloudErrorHandler;
import org.jclouds.deltacloud.handlers.DeltacloudRedirectionRetryHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@RequiresHttp
@ConfiguresRestClient
public class DeltacloudRestClientModule
extends RestClientModule<DeltacloudClient, DeltacloudAsyncClient> {
    protected AtomicReference<AuthorizationException> authException = new AtomicReference();

    public DeltacloudRestClientModule() {
        super(DeltacloudClient.class, DeltacloudAsyncClient.class);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DeltacloudErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DeltacloudErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DeltacloudErrorHandler.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(Redirection.class).to(DeltacloudRedirectionRetryHandler.class);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends DeltacloudCollection>> provideCollections(@Named(value="jclouds.session-interval") long seconds, final DeltacloudClient client) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier<Set<? extends DeltacloudCollection>>(this.authException, seconds, new Supplier<Set<? extends DeltacloudCollection>>(){

            @Override
            public Set<? extends DeltacloudCollection> get() {
                return client.getCollections();
            }
        });
    }

    @Provides
    @Images
    protected URI provideImageCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return DeltacloudRestClientModule.findCollectionWithRel((Iterable<? extends DeltacloudCollection>)collectionSupplier.get(), "images").getHref();
    }

    public static DeltacloudCollection findCollectionWithRel(Iterable<? extends DeltacloudCollection> iterable, final String rel) {
        try {
            return Iterables.find(iterable, new Predicate<DeltacloudCollection>(){

                @Override
                public boolean apply(DeltacloudCollection arg0) {
                    return arg0.getRel().equals(rel);
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("could not find rel " + rel + " in collections " + iterable);
        }
    }

    @Provides
    @HardwareProfiles
    protected URI provideHardwareProfileCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return DeltacloudRestClientModule.findCollectionWithRel((Iterable<? extends DeltacloudCollection>)collectionSupplier.get(), "hardware_profiles").getHref();
    }

    @Provides
    @Instances
    protected URI provideInstanceCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return DeltacloudRestClientModule.findCollectionWithRel((Iterable<? extends DeltacloudCollection>)collectionSupplier.get(), "instances").getHref();
    }

    @Provides
    @Realms
    protected URI provideRealmCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return DeltacloudRestClientModule.findCollectionWithRel((Iterable<? extends DeltacloudCollection>)collectionSupplier.get(), "realms").getHref();
    }

    @Provides
    @InstanceStates
    protected URI provideInstanceStateCollection(Supplier<Set<? extends DeltacloudCollection>> collectionSupplier) {
        return DeltacloudRestClientModule.findCollectionWithRel((Iterable<? extends DeltacloudCollection>)collectionSupplier.get(), "instance_states").getHref();
    }
}

