/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.deltacloud.DeltacloudClient;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.logging.Logger;

@Singleton
public abstract class InstanceState
implements Predicate<Instance> {
    private final DeltacloudClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public InstanceState(DeltacloudClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(Instance instance) {
        this.logger.trace("looking for state on instance %s", Preconditions.checkNotNull(instance, "instance"));
        instance = this.refresh(instance);
        if (instance == null || instance.getState() == Instance.State.FINISH) {
            return false;
        }
        this.logger.trace("%s: looking for instance state %s: currently: %s", new Object[]{instance.getId(), this.getState(), instance.getState()});
        return instance.getState() == this.getState();
    }

    protected abstract Instance.State getState();

    private Instance refresh(Instance instance) {
        return this.client.getInstance(instance.getHref());
    }
}

